/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.editors.parts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.workbench.forms.CommonFormUtil;
import org.eclipse.mylyn.internal.reviews.ui.IReviewAction;
import org.eclipse.mylyn.internal.reviews.ui.IReviewActionListener;
import org.eclipse.mylyn.reviews.core.model.IComment;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;

public abstract class ExpandablePart<T extends IComment, V extends ExpandablePart<T, V>> {
    private Section commentSection;
    private boolean isExpanded;
    private boolean enableToolbar = true;
    private boolean isIncomming = false;
    private final List<V> childrenParts = new ArrayList<V>();
    private IReviewActionListener actionListener;
    private ToolBarManager toolBarManager;
    private Label annotationImageLabel;
    private Label annotationsTextLabel;

    protected void addChildPart(V part) {
        this.childrenParts.add(part);
    }

    protected List<V> getChildrenParts() {
        return this.childrenParts;
    }

    public Control createControl(Composite parent, FormToolkit toolkit) {
        int style = 8192;
        if (this.canExpand()) {
            style |= 2;
        }
        this.commentSection = toolkit.createSection(parent, style |= 0x40);
        this.updateSectionText();
        this.commentSection.setTitleBarForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        GridData gd = GridDataFactory.fillDefaults().grab(true, false).create();
        if (!this.canExpand()) {
            gd.horizontalIndent = 9;
        }
        this.commentSection.setLayoutData((Object)gd);
        Composite actionsComposite = this.createSectionAnnotationsAndToolbar(this.commentSection, toolkit);
        this.toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbarControl = this.toolBarManager.createControl(actionsComposite);
        toolkit.adapt((Composite)toolbarControl);
        if (this.commentSection.isExpanded()) {
            this.isExpanded = true;
            this.fillToolBar(this.toolBarManager, this.isExpanded);
            if (this.hasContents()) {
                Composite composite = this.createSectionContents(this.commentSection, toolkit);
                this.commentSection.setClient((Control)composite);
                this.commentSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                    public void expansionStateChanged(ExpansionEvent e) {
                        ExpandablePart.this.fillToolBar(ExpandablePart.this.toolBarManager, e.getState());
                        if (ExpandablePart.this.getSection() != null && !ExpandablePart.this.getSection().isDisposed()) {
                            ExpandablePart.this.getSection().layout();
                        }
                    }
                });
            }
        }
        return this.commentSection;
    }

    protected void update() {
        this.updateSectionText();
        this.updateAnnotationsArea();
        this.updateToolbar();
    }

    private void updateSectionText() {
        if (this.commentSection != null && !this.commentSection.isDisposed()) {
            this.commentSection.setText(this.getSectionHeaderText());
        }
    }

    private void updateToolbar() {
        this.fillToolBar(this.toolBarManager, this.commentSection.isExpanded());
    }

    private void updateAnnotationsArea() {
        String annotationsText;
        ImageDescriptor annotationImage = this.getAnnotationImage();
        if (this.annotationImageLabel != null && !this.annotationImageLabel.isDisposed()) {
            if (annotationImage != null) {
                this.annotationImageLabel.setImage(CommonImages.getImage((ImageDescriptor)annotationImage));
            } else {
                this.annotationImageLabel.setImage(null);
            }
        }
        if ((annotationsText = this.getAnnotationText()) == null) {
            annotationsText = "";
        }
        if (this.annotationsTextLabel != null && !this.annotationsTextLabel.isDisposed()) {
            this.annotationsTextLabel.setText(annotationsText);
        }
    }

    protected boolean canExpand() {
        return true;
    }

    protected boolean hasContents() {
        return this.canExpand();
    }

    public Section getSection() {
        return this.commentSection;
    }

    private void fillToolBar(ToolBarManager toolbarManager, boolean expanded) {
        if (!this.enableToolbar) {
            return;
        }
        List<IReviewAction> toolbarActions = this.getToolbarActions(expanded);
        toolbarManager.removeAll();
        if (toolbarActions != null) {
            for (IReviewAction action : toolbarActions) {
                action.setActionListener(this.actionListener);
                toolbarManager.add((IAction)action);
            }
        }
        toolbarManager.markDirty();
        toolbarManager.update(true);
    }

    protected ImageHyperlink createActionHyperlink(Composite actionsComposite, FormToolkit toolkit, final IAction action) {
        if (action instanceof IReviewAction) {
            ((IReviewAction)action).setActionListener(this.actionListener);
        }
        ImageHyperlink link = toolkit.createImageHyperlink(actionsComposite, 0);
        if (action.getImageDescriptor() != null) {
            link.setImage(CommonImages.getImage((ImageDescriptor)action.getImageDescriptor()));
        } else {
            link.setText(action.getText());
        }
        link.setToolTipText(action.getToolTipText());
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                action.run();
            }
        });
        return link;
    }

    protected Composite createSectionAnnotationsAndToolbar(Section section, FormToolkit toolkit) {
        Composite toolbarComposite = toolkit.createComposite((Composite)section);
        section.setTextClient((Control)toolbarComposite);
        RowLayout rowLayout = new RowLayout();
        rowLayout.marginTop = 0;
        rowLayout.marginBottom = 0;
        toolbarComposite.setLayout((Layout)rowLayout);
        Composite annotationsComposite = toolkit.createComposite(toolbarComposite);
        rowLayout = new RowLayout();
        rowLayout.marginTop = 0;
        rowLayout.marginBottom = 0;
        rowLayout.spacing = 0;
        annotationsComposite.setLayout((Layout)rowLayout);
        this.annotationImageLabel = toolkit.createLabel(annotationsComposite, "");
        this.annotationsTextLabel = toolkit.createLabel(annotationsComposite, "");
        this.createCustomAnnotations(annotationsComposite, toolkit);
        this.updateAnnotationsArea();
        return toolbarComposite;
    }

    public boolean isExpanded() {
        return this.isExpanded && this.areChildrenExpanded();
    }

    private boolean areChildrenExpanded() {
        for (ExpandablePart child : this.childrenParts) {
            if (child.isExpanded()) continue;
            return false;
        }
        return true;
    }

    public void setExpanded(boolean expanded) {
        if (expanded != this.commentSection.isExpanded()) {
            CommonFormUtil.setExpanded((ExpandableComposite)this.commentSection, (boolean)expanded);
        }
        for (ExpandablePart child : this.childrenParts) {
            child.setExpanded(expanded);
        }
    }

    public void hookCustomActionRunListener(IReviewActionListener actionRunListener) {
        this.actionListener = actionRunListener;
    }

    public IReviewActionListener getActionListener() {
        return this.actionListener;
    }

    protected void createCustomAnnotations(Composite toolbarComposite, FormToolkit toolkit) {
    }

    public void disableToolbar() {
        this.enableToolbar = false;
    }

    public void setIncomming(boolean newIncomming) {
        this.isIncomming = newIncomming;
    }

    public boolean isIncomming() {
        return this.isIncomming;
    }

    public void dispose() {
        if (this.getSection() != null) {
            this.getSection().dispose();
        }
    }

    protected final V findPart(T comment) {
        for (ExpandablePart part : this.childrenParts) {
            if (!part.represents(comment)) continue;
            return (V)part;
        }
        return null;
    }

    protected final void updateChildren(Composite composite, FormToolkit toolkit, boolean shouldHighlight, Collection<T> childrenObjects) {
        ArrayList<ExpandablePart> toRemove = new ArrayList<ExpandablePart>();
        ArrayList<V> newParts = new ArrayList<V>();
        if (childrenObjects.size() > 0) {
            ArrayList<T> generalComments = new ArrayList<T>(childrenObjects);
            Collections.sort(generalComments, this.getComparator());
            Control prevControl = null;
            int i = 0;
            while (i < generalComments.size()) {
                IComment comment = (IComment)generalComments.get(i);
                V oldPart = this.findPart(comment);
                if (oldPart != null) {
                    Control commentControl = ((ExpandablePart)oldPart).update(composite, toolkit, (IComment)comment);
                    if (commentControl != null && !commentControl.isDisposed()) {
                        GridDataFactory.fillDefaults().grab(true, false).applyTo(commentControl);
                        if (prevControl != null) {
                            commentControl.moveBelow(prevControl);
                        } else if (composite.getChildren().length > 1) {
                            commentControl.moveAbove((Control)composite);
                        }
                        prevControl = commentControl;
                    } else {
                        Thread.dumpStack();
                    }
                    newParts.add(oldPart);
                } else {
                    V commentPart = this.createChildPart(comment);
                    ((ExpandablePart)commentPart).hookCustomActionRunListener(this.actionListener);
                    newParts.add(commentPart);
                    Control commentControl = ((ExpandablePart)commentPart).createControl(composite, toolkit);
                    GridDataFactory.fillDefaults().grab(true, false).applyTo(commentControl);
                    if (prevControl != null) {
                        commentControl.moveBelow(prevControl);
                    } else if (composite.getChildren().length > 1) {
                        commentControl.moveAbove((Control)composite);
                    }
                    prevControl = commentControl;
                }
                ++i;
            }
            for (ExpandablePart part : this.childrenParts) {
                if (newParts.contains(part)) continue;
                toRemove.add(part);
            }
        } else {
            for (ExpandablePart part : this.childrenParts) {
                toRemove.add(part);
            }
        }
        for (ExpandablePart part : toRemove) {
            part.dispose();
        }
        this.childrenParts.clear();
        this.childrenParts.addAll(newParts);
    }

    protected abstract V createChildPart(T var1);

    protected abstract Control update(Composite var1, FormToolkit var2, T var3);

    protected abstract boolean represents(T var1);

    protected abstract Comparator<T> getComparator();

    protected abstract List<IReviewAction> getToolbarActions(boolean var1);

    protected abstract String getAnnotationText();

    protected abstract ImageDescriptor getAnnotationImage();

    protected abstract String getSectionHeaderText();

    protected abstract Composite createSectionContents(Section var1, FormToolkit var2);
}

