/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;

public class AutServerLauncher {
    public static final String PATH_SEPARATOR = System.getProperty("path.separator");
    private static final String ENV_VAR_USE_CLASSIC_CLASSLOADER = "TEST_USE_CLASSIC_CL";

    private AutServerLauncher() {
    }

    public static void main(String[] args) {
        URL[] urls = PathSplitter.createUrls(args[2]);
        String useClassicClassLoaderValue = null;
        try {
            useClassicClassLoaderValue = System.getenv(ENV_VAR_USE_CLASSIC_CLASSLOADER);
        }
        catch (Throwable throwable) {}
        if (useClassicClassLoaderValue == null) {
            useClassicClassLoaderValue = System.getProperty(ENV_VAR_USE_CLASSIC_CLASSLOADER);
        }
        URLClassLoader autServerClassLoader = useClassicClassLoaderValue != null ? new UrlClassicClassLoader(urls, ClassLoader.getSystemClassLoader().getParent()) : new UrlDefaultClassLoader(urls, ClassLoader.getSystemClassLoader());
        Thread.currentThread().setContextClassLoader(autServerClassLoader);
        try {
            Class<?> autServerClass = autServerClassLoader.loadClass("org.eclipse.jubula.rc.common.AUTServer");
            Method mainMethod = autServerClass.getMethod("main", args.getClass());
            mainMethod.invoke(null, new Object[]{args});
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.exit(27);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            System.exit(28);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            System.exit(23);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            System.exit(29);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            System.exit(30);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            System.exit(31);
        }
    }

    private static class PathSplitter {
        private PathSplitter() {
        }

        private static String[] split(String paths) {
            StringTokenizer pathElems = new StringTokenizer(paths, PATH_SEPARATOR);
            String[] pathElements = new String[pathElems.countTokens()];
            int i = 0;
            while (pathElems.hasMoreTokens()) {
                pathElements[i] = pathElems.nextToken();
                ++i;
            }
            return pathElements;
        }

        public static URL[] createUrls(String classpath) {
            String[] paths = PathSplitter.split(classpath);
            int pathLength = paths.length;
            URL[] urls = new URL[pathLength];
            try {
                int i = 0;
                while (i < pathLength) {
                    URL url;
                    File file = new File(paths[i]);
                    urls[i] = url = file.toURI().toURL();
                    ++i;
                }
            }
            catch (MalformedURLException malformedURLException) {
                return new URL[0];
            }
            return urls;
        }
    }

    private static class UrlClassicClassLoader
    extends URLClassLoader {
        public UrlClassicClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                try {
                    if (name.startsWith("org.eclipse.swt")) {
                        return super.loadClass(name, resolve);
                    }
                    c = this.findClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return super.loadClass(name, resolve);
                }
                catch (SecurityException securityException) {
                    return super.loadClass(name, resolve);
                }
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }

        public Class loadClass(String name) throws ClassNotFoundException {
            return this.loadClass(name, false);
        }
    }

    private static class UrlDefaultClassLoader
    extends URLClassLoader {
        public UrlDefaultClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                try {
                    c = this.findClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return super.loadClass(name, resolve);
                }
                catch (SecurityException securityException) {
                    return super.loadClass(name, resolve);
                }
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }

        public Class loadClass(String name) throws ClassNotFoundException {
            return this.loadClass(name, false);
        }

        public URL getResource(String name) {
            URL resourceUrl = this.findResource(name);
            return resourceUrl != null ? resourceUrl : super.getResource(name);
        }
    }
}

