/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.log.stream;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.equinox.internal.log.stream.LogEntrySource;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogReaderService;
import org.osgi.service.log.stream.LogStreamProvider;
import org.osgi.util.pushstream.PushStream;
import org.osgi.util.pushstream.PushStreamBuilder;
import org.osgi.util.pushstream.PushStreamProvider;
import org.osgi.util.pushstream.QueuePolicyOption;
import org.osgi.util.tracker.ServiceTracker;

public class LogStreamProviderImpl
implements LogStreamProvider {
    private final PushStreamProvider pushStreamProvider = new PushStreamProvider();
    private final ServiceTracker<LogReaderService, AtomicReference<LogReaderService>> logReaderService;
    private final WeakHashMap<LogEntrySource, Boolean> weakMap = new WeakHashMap();
    private final Set<LogEntrySource> logEntrySources = Collections.newSetFromMap(this.weakMap);
    private final ReentrantReadWriteLock historyLock = new ReentrantReadWriteLock();
    private final ExecutorService executor;

    public LogStreamProviderImpl(ServiceTracker<LogReaderService, AtomicReference<LogReaderService>> logReaderService, ExecutorService executor) {
        this.logReaderService = logReaderService;
        this.executor = executor;
    }

    @Override
    public PushStream<LogEntry> createStream(LogStreamProvider.Options ... options) {
        ServiceTracker<LogReaderService, AtomicReference<LogReaderService>> withHistory = null;
        if (options != null) {
            LogStreamProvider.Options[] optionsArray = options;
            int n = options.length;
            int n2 = 0;
            while (n2 < n) {
                LogStreamProvider.Options option = optionsArray[n2];
                if (LogStreamProvider.Options.HISTORY.equals((Object)option)) {
                    withHistory = this.logReaderService;
                }
                ++n2;
            }
        }
        this.historyLock.writeLock().lock();
        try {
            LogEntrySource logEntrySource = new LogEntrySource(withHistory);
            PushStreamBuilder streamBuilder = this.pushStreamProvider.buildStream(logEntrySource);
            LinkedBlockingQueue historyQueue = new LinkedBlockingQueue();
            PushStream logStream = (PushStream)streamBuilder.withBuffer(historyQueue).withExecutor(this.executor).withParallelism(1).withQueuePolicy(QueuePolicyOption.DISCARD_OLDEST).build();
            logEntrySource.setLogStream(logStream);
            this.logEntrySources.add(logEntrySource);
            PushStream pushStream = logStream;
            return pushStream;
        }
        finally {
            this.historyLock.writeLock().unlock();
        }
    }

    public void logged(LogEntry entry) {
        this.historyLock.readLock().lock();
        try {
            for (LogEntrySource logEntrySource : this.logEntrySources) {
                logEntrySource.logged(entry);
            }
        }
        finally {
            this.historyLock.readLock().unlock();
        }
    }

    public void close() {
        this.historyLock.readLock().lock();
        try {
            for (LogEntrySource logEntrySource : this.logEntrySources) {
                PushStream<LogEntry> logStream = logEntrySource.getLogStream();
                try {
                    logStream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            this.historyLock.readLock().unlock();
        }
    }
}

