/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.epp.internal.mpc.core.MarketplaceClientCore;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUiPlugin;
import org.eclipse.epp.internal.mpc.ui.Messages;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class MarketplaceClientUi {
    private static final String DOT_FEATURE_DOT_GROUP = ".feature.group";
    public static final String BUNDLE_ID = "org.eclipse.epp.mpc.ui";

    public static ILog getLog() {
        return Platform.getLog((Bundle)Platform.getBundle((String)BUNDLE_ID));
    }

    public static void error(String message, Object ... params) {
        MarketplaceClientUi.log(4, message, params);
    }

    public static void error(String message, Throwable exception) {
        MarketplaceClientUi.log(4, message, exception);
    }

    public static void error(Throwable exception) {
        MarketplaceClientUi.error(null, exception);
    }

    public static void log(int severity, String message) {
        MarketplaceClientUi.getLog().log(MarketplaceClientUi.newStatus(severity, message, null));
    }

    public static void log(int severity, String message, Throwable exception) {
        MarketplaceClientUi.getLog().log(MarketplaceClientUi.newStatus(severity, message, exception));
    }

    public static void log(int severity, String message, Object ... params) {
        MarketplaceClientUi.getLog().log(MarketplaceClientUi.newStatus(severity, message, params));
    }

    public static IStatus newStatus(int severity, String message, Object ... params) {
        String formattedMessage = message;
        if (message != null && params != null && params.length > 0) {
            formattedMessage = NLS.bind((String)message, (Object[])params);
        }
        Throwable exception = MarketplaceClientUi.findException(params);
        return MarketplaceClientUi.newStatus(severity, formattedMessage, exception);
    }

    public static IStatus newStatus(int severity, String message, Throwable exception) {
        if (message == null) {
            String exceptionMessage = exception.getMessage();
            if (exceptionMessage == null) {
                exceptionMessage = exception.getClass().getSimpleName();
            }
            message = NLS.bind((String)Messages.MarketplaceClientUi_unexpectedException_reason, (Object)exceptionMessage);
        }
        Status status = new Status(severity, BUNDLE_ID, message, exception);
        return status;
    }

    private static Throwable findException(Object ... params) {
        Throwable exception = null;
        int i = params.length - 1;
        while (i >= 0) {
            if (params[i] instanceof Throwable) {
                exception = (Throwable)params[i];
                break;
            }
            --i;
        }
        return exception;
    }

    @Deprecated
    public static IStatus computeStatus(Exception e, String message) {
        return MarketplaceClientCore.computeStatus((Throwable)e, (String)message);
    }

    @Deprecated
    public static IStatus computeWellknownProblemStatus(Throwable exception) {
        return MarketplaceClientCore.computeWellknownProblemStatus((Throwable)exception);
    }

    public static BundleContext getBundleContext() {
        return MarketplaceClientUiPlugin.getInstance().getBundle().getBundleContext();
    }

    public static Map<String, IInstallableUnit> computeInstalledIUsById(IProgressMonitor monitor) {
        HashMap<String, IInstallableUnit> iUs = new HashMap<String, IInstallableUnit>();
        BundleContext bundleContext = MarketplaceClientUi.getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(IProvisioningAgent.class);
        if (serviceReference != null) {
            IProvisioningAgent agent = (IProvisioningAgent)bundleContext.getService(serviceReference);
            try {
                IProfile profile;
                IProfileRegistry profileRegistry = (IProfileRegistry)agent.getService(IProfileRegistry.SERVICE_NAME);
                if (profileRegistry != null && (profile = profileRegistry.getProfile(ProvisioningUI.getDefaultUI().getProfileId())) != null) {
                    IQueryResult result = profile.available(QueryUtil.createIUGroupQuery(), monitor);
                    for (IInstallableUnit unit : result) {
                        iUs.put(unit.getId(), unit);
                    }
                }
            }
            finally {
                bundleContext.ungetService(serviceReference);
            }
        }
        return iUs;
    }

    public static Set<String> computeInstalledFeatures(IProgressMonitor monitor) {
        Map<String, IInstallableUnit> iusById = MarketplaceClientUi.computeInstalledIUsById(monitor);
        HashSet<String> features = new HashSet<String>(iusById.keySet());
        if (features.isEmpty()) {
            IBundleGroupProvider[] bundleGroupProviders;
            IBundleGroupProvider[] iBundleGroupProviderArray = bundleGroupProviders = Platform.getBundleGroupProviders();
            int n = bundleGroupProviders.length;
            int n2 = 0;
            while (n2 < n) {
                IBundleGroup[] bundleGroups;
                IBundleGroupProvider provider = iBundleGroupProviderArray[n2];
                if (monitor.isCanceled()) break;
                IBundleGroup[] iBundleGroupArray = bundleGroups = provider.getBundleGroups();
                int n3 = bundleGroups.length;
                int n4 = 0;
                while (n4 < n3) {
                    IBundleGroup group = iBundleGroupArray[n4];
                    String identifier = group.getIdentifier();
                    if (!identifier.endsWith(DOT_FEATURE_DOT_GROUP)) {
                        identifier = String.valueOf(identifier) + DOT_FEATURE_DOT_GROUP;
                    }
                    features.add(identifier);
                    ++n4;
                }
                ++n2;
            }
        }
        return features;
    }

    public static void setDefaultHelp(Control control) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(control, "org.eclipse.epp.mpc.help.ui.userGuide");
    }

    public static void handle(Throwable t, int style) {
        MarketplaceClientUi.handle((IStatus)new Status(4, BUNDLE_ID, t.getLocalizedMessage(), t), style);
    }

    public static void handle(IStatus status, int style) {
        Runnable logRunnable;
        Display workbenchDisplay;
        IWorkbench workbench;
        if (PlatformUI.isWorkbenchRunning() && (workbench = PlatformUI.getWorkbench()) != null && !(workbenchDisplay = workbench.getDisplay()).isDisposed() && MarketplaceClientUi.runIn(workbenchDisplay, logRunnable = () -> {
            ILog log;
            IWorkbench workbench1;
            if (!workbenchDisplay.isDisposed() && PlatformUI.isWorkbenchRunning() && (workbench1 = PlatformUI.getWorkbench()) != null) {
                try {
                    StatusManager.getManager().handle(status, style);
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((log = MarketplaceClientUi.getLog()) != null) {
                log.log(status);
            } else {
                System.out.println(status);
            }
        })) {
            return;
        }
        ILog log = MarketplaceClientUi.getLog();
        if (log != null) {
            log.log(status);
        } else {
            System.out.println(status);
        }
    }

    private static boolean runIn(Display display, Runnable runnable) {
        if (display == null || display.isDisposed()) {
            return false;
        }
        if (display == Display.getCurrent()) {
            if (display.isDisposed()) {
                return false;
            }
            runnable.run();
            return true;
        }
        try {
            display.asyncExec(runnable);
            return true;
        }
        catch (SWTException e) {
            if (e.code == 45) {
                return false;
            }
            throw e;
        }
    }

    public static boolean useNativeBorders() {
        IPreferencesService service = Platform.getPreferencesService();
        return service.getBoolean(BUNDLE_ID, "native-borders", true, new IScopeContext[]{InstanceScope.INSTANCE});
    }
}

