/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.design.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecoretools.design.service.GenModelAutoReload;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.sirius.business.api.session.ModelChangeTrigger;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class GenModelUpdateGenFeatureContainment
implements ModelChangeTrigger {
    private Session session;
    public static final NotificationFilter IS_EREFENCE_CONTAINMENT = new NotificationFilter.Custom(){

        public boolean matches(Notification notification) {
            return notification.getFeature() == EcorePackage.eINSTANCE.getEReference_Containment();
        }
    };
    public static final NotificationFilter SHOULD_UPDATE = GenModelAutoReload.IS_TOUCH.negated().and(GenModelAutoReload.IS_ECORE.and(IS_EREFENCE_CONTAINMENT));

    public GenModelUpdateGenFeatureContainment(Session set) {
        this.session = set;
    }

    public Option<Command> localChangesAboutToCommit(Collection<Notification> notifications) {
        final ArrayList toBeUpdated = Lists.newArrayList();
        for (Notification notif : notifications) {
            if (!SHOULD_UPDATE.matches(notif)) continue;
            EReference updatedRef = (EReference)notif.getNotifier();
            for (EStructuralFeature.Setting xRef : this.session.getSemanticCrossReferencer().getInverseReferences((EObject)updatedRef)) {
                if (!(xRef.getEObject() instanceof GenFeature)) continue;
                toBeUpdated.add((GenFeature)xRef.getEObject());
            }
        }
        if (toBeUpdated.size() > 0) {
            RecordingCommand result = new RecordingCommand(this.session.getTransactionalEditingDomain()){

                protected void doExecute() {
                    for (GenFeature genFeature : toBeUpdated) {
                        if (!(genFeature.getEcoreFeature() instanceof EReference)) continue;
                        if (((EReference)genFeature.getEcoreFeature()).isContainment()) {
                            genFeature.setChildren(true);
                            genFeature.setNotify(true);
                            genFeature.setCreateChild(true);
                            continue;
                        }
                        genFeature.setChildren(false);
                        genFeature.setNotify(false);
                        genFeature.setCreateChild(false);
                    }
                }
            };
            return Options.newSome((Object)result);
        }
        return Options.newNone();
    }

    public int priority() {
        return -1;
    }
}

