/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.explorer.bundle;

import java.io.File;
import org.eclipse.emf.cdo.internal.explorer.checkouts.CDOCheckoutManagerImpl;
import org.eclipse.emf.cdo.internal.explorer.repositories.CDORepositoryManagerImpl;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMBundle;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.OSGiActivator;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.eclipse.net4j.util.om.trace.OMTracer;

public abstract class OM {
    public static final String BUNDLE_ID = "org.eclipse.emf.cdo.explorer";
    public static final OMBundle BUNDLE = OMPlatform.INSTANCE.bundle("org.eclipse.emf.cdo.explorer", OM.class);
    public static final OMTracer DEBUG = BUNDLE.tracer("debug");
    public static final OMLogger LOG = BUNDLE.logger();
    private static final String STATE_LOCATION = OMPlatform.INSTANCE.getProperty("org.eclipse.emf.cdo.explorer.stateLocation");
    private static String stateLocation;
    private static CDORepositoryManagerImpl repositoryManager;
    private static CDOCheckoutManagerImpl checkoutManager;

    public static String getStateLocation() {
        return stateLocation;
    }

    public static void initializeManagers(File stateLocation) {
        Exception exception;
        OM.disposeManagers();
        if (repositoryManager == null && (exception = LifecycleUtil.activateSilent((Object)(repositoryManager = new CDORepositoryManagerImpl(new File(stateLocation, "rp"))))) != null) {
            LOG.error((Throwable)exception);
        }
        if (checkoutManager == null && (exception = LifecycleUtil.activateSilent((Object)(checkoutManager = new CDOCheckoutManagerImpl(new File(stateLocation, "co"))))) != null) {
            LOG.error((Throwable)exception);
        }
    }

    public static void disposeManagers() {
        Exception exception;
        if (checkoutManager != null) {
            exception = LifecycleUtil.deactivate((Object)checkoutManager);
            if (exception != null) {
                LOG.error((Throwable)exception);
            }
            checkoutManager = null;
        }
        if (repositoryManager != null) {
            exception = LifecycleUtil.deactivate((Object)repositoryManager);
            if (exception != null) {
                LOG.error((Throwable)exception);
            }
            repositoryManager = null;
        }
    }

    public static CDORepositoryManagerImpl getRepositoryManager() {
        return repositoryManager;
    }

    public static CDOCheckoutManagerImpl getCheckoutManager() {
        return checkoutManager;
    }

    public static final class Activator
    extends OSGiActivator {
        public Activator() {
            super(BUNDLE);
        }

        protected void doStart() throws Exception {
            super.doStart();
            stateLocation = STATE_LOCATION != null ? STATE_LOCATION : BUNDLE.getStateLocation();
            OM.initializeManagers(new File(stateLocation));
        }

        protected void doStop() throws Exception {
            OM.disposeManagers();
            super.doStop();
        }
    }
}

