/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.checkouts;

import org.eclipse.emf.cdo.explorer.CDOExplorerElement;
import org.eclipse.emf.cdo.explorer.ui.checkouts.CDOCheckoutContentProvider;
import org.eclipse.emf.cdo.explorer.ui.checkouts.CDOCheckoutState;
import org.eclipse.emf.cdo.explorer.ui.checkouts.CDOCheckoutStateManager;
import org.eclipse.emf.cdo.internal.ui.ViewerUtil;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.ui.views.ContainerItemProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;

public class CDOCheckoutLabelProvider
extends LabelProvider
implements ICommonLabelProvider,
IColorProvider,
DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private static final Image ERROR_IMAGE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
    private static final IEditorRegistry EDITOR_REGISTRY = PlatformUI.getWorkbench().getEditorRegistry();
    private final EditorRegistryListener editorRegistryListener = new EditorRegistryListener();
    private ICommonContentExtensionSite config;
    private CDOCheckoutStateManager stateManager;

    public CDOCheckoutLabelProvider() {
    }

    public CDOCheckoutLabelProvider(CDOCheckoutContentProvider contentProvider) {
        this.stateManager = contentProvider.getStateManager();
    }

    public void init(ICommonContentExtensionSite config) {
        this.config = config;
        EDITOR_REGISTRY.addPropertyListener((IPropertyListener)this.editorRegistryListener);
    }

    public void dispose() {
        EDITOR_REGISTRY.removePropertyListener((IPropertyListener)this.editorRegistryListener);
        super.dispose();
    }

    public void saveState(IMemento aMemento) {
    }

    public void restoreState(IMemento aMemento) {
    }

    public void fireLabelProviderChanged() {
        this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
    }

    public Color getForeground(Object object) {
        try {
            CDOCheckoutState.LabelProvider provider = this.getStateManager().getLabelProvider(object);
            if (provider != null) {
                return provider.getForeground(object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Color getBackground(Object object) {
        try {
            CDOCheckoutState.LabelProvider provider = this.getStateManager().getLabelProvider(object);
            if (provider != null) {
                return provider.getBackground(object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String getDescription(Object object) {
        if (object instanceof CDOExplorerElement) {
            CDOExplorerElement element = (CDOExplorerElement)object;
            return element.getDescription();
        }
        return null;
    }

    public StyledString getStyledText(Object object) {
        try {
            CDOCheckoutState.LabelProvider provider = this.getStateManager().getLabelProvider(object);
            if (provider != null) {
                return provider.getStyledText(object);
            }
        }
        catch (Exception provider) {
            // empty catch block
        }
        String text = this.getText(object);
        return new StyledString(text);
    }

    public String getText(Object object) {
        if (object instanceof ViewerUtil.Pending) {
            ViewerUtil.Pending pending = (ViewerUtil.Pending)object;
            return pending.getText();
        }
        try {
            String text;
            CDOCheckoutState.LabelProvider provider = this.getStateManager().getLabelProvider(object);
            if (provider != null && !StringUtil.isEmpty((String)(text = provider.getText(object)))) {
                return text;
            }
        }
        catch (Exception provider) {
            // empty catch block
        }
        try {
            String text = super.getText(object);
            if (!StringUtil.isEmpty((String)text)) {
                return text;
            }
        }
        catch (Exception text) {
            // empty catch block
        }
        try {
            EObject eObject;
            EClass eClass;
            String text;
            if (object instanceof EObject && !StringUtil.isEmpty((String)(text = this.getText(eClass = (eObject = (EObject)object).eClass())))) {
                return text;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object.getClass().getSimpleName();
    }

    public Image getImage(Object object) {
        if (object instanceof ViewerUtil.Pending) {
            return ContainerItemProvider.PENDING_IMAGE;
        }
        try {
            CDOCheckoutState.LabelProvider provider = this.getStateManager().getLabelProvider(object);
            if (provider != null) {
                return provider.getImage(object);
            }
        }
        catch (Exception provider) {
            // empty catch block
        }
        try {
            return super.getImage(object);
        }
        catch (Exception ex) {
            return ERROR_IMAGE;
        }
    }

    public CDOCheckoutStateManager getStateManager() {
        String viewerID;
        CDOCheckoutContentProvider contentProvider;
        if (this.stateManager == null && (contentProvider = CDOCheckoutContentProvider.getInstance(viewerID = this.config.getService().getViewerId())) != null) {
            this.stateManager = contentProvider.getStateManager();
        }
        return this.stateManager;
    }

    public void setStateManager(CDOCheckoutStateManager stateManager) {
        this.stateManager = stateManager;
    }

    private class EditorRegistryListener
    implements IPropertyListener {
        private EditorRegistryListener() {
        }

        public void propertyChanged(Object source, int propId) {
            if (propId == 1) {
                CDOCheckoutLabelProvider.this.fireLabelProviderChanged();
            }
        }
    }
}

