/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.schemaobjecteditor.ui.common;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class TextFormEntry {
    private Control _nameLabel;
    private Text _text;
    private Button _button;
    private FormToolkit _toolkit;
    private int _colSpan;

    public TextFormEntry(Composite parent, FormToolkit toolkit, int textStyle, String labelText, String buttonText, int colSpan) {
        this._toolkit = toolkit;
        this._colSpan = colSpan;
        this.createControl(parent, toolkit, textStyle, labelText, buttonText);
    }

    private void createControl(Composite parent, FormToolkit toolkit, int textStyle, String labelText, String buttonText) {
        Layout layout;
        this._nameLabel = this._toolkit.createLabel(parent, labelText);
        this._nameLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this._text = this._toolkit.createText(parent, "", textStyle);
        boolean buttonCreated = false;
        if (buttonText != null && buttonText.trim().length() != 0) {
            this._button = this._toolkit.createButton(parent, buttonText, 0);
            buttonCreated = true;
        }
        if ((layout = parent.getLayout()) instanceof GridLayout) {
            GridLayout parentLayout = (GridLayout)layout;
            int numColumns = parentLayout.numColumns;
            if (numColumns < 2) {
                return;
            }
            if (!buttonCreated) {
                int numSpan = numColumns;
                if (this._colSpan < numColumns && this._colSpan >= 2) {
                    numSpan = this._colSpan;
                }
                int textSpan = numSpan - 1;
                GridData gd = new GridData();
                this._nameLabel.setLayoutData((Object)gd);
                gd = new GridData(768);
                gd.horizontalSpan = textSpan;
                this._text.setLayoutData((Object)gd);
            } else {
                if (numColumns < 3) {
                    return;
                }
                int numSpan = numColumns;
                if (this._colSpan < numColumns && this._colSpan >= 3) {
                    numSpan = this._colSpan;
                }
                int textSpan = numSpan - 2;
                GridData gd = new GridData();
                this._nameLabel.setLayoutData((Object)gd);
                gd = new GridData(768);
                gd.horizontalSpan = textSpan;
                this._text.setLayoutData((Object)gd);
                gd = new GridData();
                this._button.setLayoutData((Object)gd);
            }
        } else if (layout instanceof TableWrapLayout) {
            TableWrapLayout parentLayout = (TableWrapLayout)layout;
            int numColumns = parentLayout.numColumns;
            if (numColumns < 2) {
                return;
            }
            if (!buttonCreated) {
                int numSpan = numColumns;
                if (this._colSpan < numColumns && this._colSpan >= 2) {
                    numSpan = this._colSpan;
                }
                int textSpan = numSpan - 1;
                TableWrapData td = new TableWrapData();
                td.valign = 32;
                this._nameLabel.setLayoutData((Object)td);
                td = new TableWrapData(256);
                td.colspan = textSpan;
                td.valign = 32;
                this._text.setLayoutData((Object)td);
            } else {
                if (numColumns < 3) {
                    return;
                }
                int numSpan = numColumns;
                if (this._colSpan < numColumns && this._colSpan >= 3) {
                    numSpan = this._colSpan;
                }
                int textSpan = numSpan - 2;
                TableWrapData td = new TableWrapData();
                td.valign = 32;
                this._nameLabel.setLayoutData((Object)td);
                td = new TableWrapData(256);
                td.colspan = textSpan;
                td.valign = 32;
                this._text.setLayoutData((Object)td);
                td = new TableWrapData();
                this._button.setLayoutData((Object)td);
            }
        }
        this._toolkit.paintBordersFor(parent);
    }

    public Button getButton() {
        return this._button;
    }

    public Control getNameLabel() {
        return this._nameLabel;
    }

    public Text getText() {
        return this._text;
    }
}

