/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.fields.text;

import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.scout.sdk.s2e.ui.fields.text.StyledTextEx;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.AbstractHyperlink;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class TextField
extends Composite {
    public static final int TYPE_LABEL = 1;
    public static final int TYPE_HYPERLINK = 2;
    public static final int TYPE_IMAGE = 4;
    public static final int TYPE_MULTI_LINE = 8;
    public static final int DEFAULT_LABEL_WIDTH = 150;
    private Control m_label;
    private Label m_imgLabel;
    private StyledTextEx m_text;
    private Color m_backupTextBackground;
    private final int m_labelColumnWidth;
    private final int m_type;

    public TextField(Composite parent) {
        this(parent, 1);
    }

    public TextField(Composite parent, int type) {
        this(parent, type, 150);
    }

    public TextField(Composite parent, int type, int labelWidth) {
        super(parent, 0);
        this.m_labelColumnWidth = labelWidth;
        this.m_type = type;
        this.createContent(this);
    }

    protected void createContent(Composite parent) {
        boolean hasLabel = this.hasLabel();
        boolean isHyperLinkLabel = this.isHyperlinkLabel();
        boolean hasImage = this.hasImage();
        boolean isMultiLine = this.isMultiLine();
        if (isHyperLinkLabel) {
            Hyperlink hyperlink = new Hyperlink(parent, 0);
            hyperlink.setUnderlined(true);
            Color fg = JFaceColors.getHyperlinkText((Display)parent.getDisplay());
            if (fg == null) {
                fg = parent.getDisplay().getSystemColor(36);
            }
            hyperlink.setForeground(fg);
            this.m_label = hyperlink;
        } else {
            this.m_label = new Label(parent, 0);
        }
        this.m_label.setVisible(hasLabel);
        if (hasImage) {
            this.m_imgLabel = new Label(parent, 0);
            this.m_imgLabel.setImage(this.getImage());
        }
        int textStyle = 2048;
        textStyle = isMultiLine ? (textStyle |= 2) : (textStyle |= 4);
        this.m_text = new StyledTextEx(parent, textStyle);
        int textFieldMarginLeft = 0;
        int imgOffset = 0;
        int labelOffset = 0;
        if (hasLabel) {
            labelOffset = this.getLabelWidth();
        }
        if (hasImage) {
            imgOffset = 22;
        }
        if (hasLabel || hasImage) {
            textFieldMarginLeft = 5;
        }
        parent.setLayout((Layout)new FormLayout());
        FormData labelData = new FormData();
        labelData.top = isHyperLinkLabel ? new FormAttachment(0, 3) : new FormAttachment(0, 4);
        labelData.right = new FormAttachment((Control)this.m_text, -textFieldMarginLeft - imgOffset);
        this.m_label.setLayoutData((Object)labelData);
        FormData textData = new FormData();
        textData.top = new FormAttachment(0, 0);
        textData.right = new FormAttachment(100, 0);
        textData.left = new FormAttachment(0, textFieldMarginLeft + labelOffset + imgOffset);
        if (isMultiLine) {
            textData.bottom = new FormAttachment(100, 0);
        }
        this.m_text.setLayoutData(textData);
        if (this.m_imgLabel != null) {
            FormData imgData = new FormData();
            imgData.top = new FormAttachment(0, 5);
            imgData.left = new FormAttachment(0, labelOffset + 6);
            this.m_imgLabel.setLayoutData((Object)imgData);
        }
    }

    protected boolean isMultiLine() {
        return (this.getType() & 8) != 0;
    }

    protected boolean hasLabel() {
        return (this.getType() & 2) != 0 || (this.getType() & 1) != 0;
    }

    protected boolean hasImage() {
        return (this.getType() & 4) != 0;
    }

    protected boolean isHyperlinkLabel() {
        return (this.getType() & 2) != 0;
    }

    public void addFocusListener(FocusListener listener) {
        this.m_text.addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.m_text.removeFocusListener(listener);
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        this.m_text.addVerifyListener(verifyListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        this.m_text.removeVerifyListener(verifyListener);
    }

    public void addModifyListener(ModifyListener listener) {
        this.m_text.addModifyListener(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.m_text.removeModifyListener(listener);
    }

    public void removeHyperlinkListener(IHyperlinkListener listener) {
        if (!this.isHyperlinkLabel()) {
            return;
        }
        ((AbstractHyperlink)this.m_label).removeHyperlinkListener(listener);
    }

    public void addHyperlinkListener(IHyperlinkListener listener) {
        if (!this.isHyperlinkLabel()) {
            return;
        }
        ((AbstractHyperlink)this.m_label).addHyperlinkListener(listener);
    }

    public void setLabelText(String text) {
        if (text == null) {
            text = "";
        }
        if (this.isHyperlinkLabel()) {
            ((Hyperlink)this.m_label).setText(text);
        } else {
            ((Label)this.m_label).setText(text);
        }
    }

    public String getLabelText() {
        if (this.isHyperlinkLabel()) {
            return ((AbstractHyperlink)this.m_label).getText();
        }
        return ((Label)this.m_label).getText();
    }

    public void setToolTipText(String tooltip) {
        this.m_label.setToolTipText(tooltip);
        this.m_text.setToolTipText(tooltip);
        super.setToolTipText(tooltip);
    }

    public Menu getMenu() {
        return this.m_text.getMenu();
    }

    public void setMenu(Menu menu) {
        this.m_text.setMenu(menu);
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        this.m_text.setText(text);
    }

    public String getText() {
        return this.m_text.getText();
    }

    public void setEditable(boolean editable) {
        this.m_text.setEditable(editable);
    }

    public boolean getEditable() {
        return this.m_text.getEditable();
    }

    public boolean isEditable() {
        return this.m_text.getEditable();
    }

    public boolean setFocus() {
        return this.m_text.setFocus();
    }

    public StyledTextEx getTextComponent() {
        return this.m_text;
    }

    public Control getLabelComponent() {
        return this.m_label;
    }

    public Label getImageComponent() {
        return this.m_imgLabel;
    }

    public Point getSelection() {
        return this.m_text.getSelection();
    }

    public void setSelection(int start) {
        this.m_text.setSelection(start);
    }

    public void setSelection(Point point) {
        this.m_text.setSelection(point);
    }

    public boolean getEnabled() {
        if (this.m_text == null || this.m_text.isDisposed()) {
            return super.getEnabled();
        }
        return this.m_text.getEnabled();
    }

    public boolean isEnabled() {
        boolean enabled = super.isEnabled();
        if (this.m_text == null || this.m_text.isDisposed()) {
            return enabled;
        }
        return enabled && this.m_text.getEnabled();
    }

    public void setEnabled(boolean enabled) {
        if (this.m_backupTextBackground == null) {
            this.m_backupTextBackground = this.m_text.getBackground();
        }
        this.m_text.setEnabled(enabled);
        this.m_label.setEnabled(enabled);
        if (enabled) {
            this.m_text.setBackground(this.m_backupTextBackground);
        } else {
            this.m_text.setBackground(this.getDisplay().getSystemColor(19));
        }
    }

    public int getLabelWidth() {
        return this.m_labelColumnWidth;
    }

    public int getType() {
        return this.m_type;
    }

    public Image getImage() {
        if (this.m_imgLabel == null) {
            return null;
        }
        return this.m_imgLabel.getImage();
    }

    public void setImage(Image image) {
        if (this.m_imgLabel == null) {
            return;
        }
        this.m_imgLabel.setImage(image);
    }
}

