/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.locator;

import java.util.Optional;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.papyrus.uml.diagram.sequence.figures.DestructionEventNodePlate;
import org.eclipse.papyrus.uml.diagram.sequence.figures.LifelineFigure;
import org.eclipse.papyrus.uml.diagram.sequence.locator.CenterLocator;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.TimeConstraint;
import org.eclipse.uml2.uml.TimeObservation;

public class TimeElementLocator
implements IBorderItemLocator {
    private final IBorderItemLocator centeringDelegate;
    private IFigure parentFigure;
    private Rectangle constraint;
    private ToIntFunction<? super Rectangle> sideFunction;

    public TimeElementLocator(IFigure parentFigure, ToIntFunction<? super Rectangle> sideFunction) {
        this.setParentFigure(parentFigure);
        this.sideFunction = sideFunction;
        this.centeringDelegate = new CenterLocator(parentFigure, 0);
    }

    public void setConstraint(Rectangle constraint) {
        this.constraint = constraint;
    }

    private Rectangle getConstraint() {
        return this.constraint;
    }

    public Rectangle getValidLocation(Rectangle proposedLocation, IFigure borderItem) {
        Rectangle realLocation = new Rectangle(proposedLocation);
        Point newTopLeft = this.locateOnBorder(realLocation, borderItem);
        realLocation.setLocation(newTopLeft);
        return realLocation;
    }

    public int getCurrentSideOfParent() {
        if (this.getConstraint().y() >= 10) {
            return 4;
        }
        return 1;
    }

    public void relocate(IFigure borderItem) {
        Dimension size = this.getSize(borderItem);
        Rectangle rectSuggested = new Rectangle(this.getPreferredLocation(borderItem), size);
        borderItem.setBounds(rectSuggested);
    }

    protected Point locateOnBorder(Rectangle rectSuggested, IFigure borderItem) {
        Point relativeItem = rectSuggested.getTopLeft();
        Rectangle parentBounds = this.getParentFigure().getBounds();
        Rectangle itemBounds = borderItem.getBounds();
        int side = this.sideFunction.applyAsInt((Rectangle)rectSuggested);
        switch (side) {
            case 8: {
                relativeItem.setLocation(-(itemBounds.width() / 2), this.getLifelineHead().height() / 2);
                break;
            }
            case 16: {
                relativeItem.setLocation(parentBounds.width() - itemBounds.width() / 2, this.getLifelineHead().height() / 2);
                break;
            }
            case 1: {
                relativeItem.setLocation((parentBounds.width() - rectSuggested.width()) / 2, 0);
                break;
            }
            case 4: {
                relativeItem.setLocation((parentBounds.width() - rectSuggested.width()) / 2, parentBounds.height());
                break;
            }
            case 2: {
                if (this.isOnDestructionOccurrence()) {
                    relativeItem.setLocation((parentBounds.width() - itemBounds.width()) / 2, parentBounds.height() / 2);
                    break;
                }
                return this.centeringDelegate.getValidLocation(rectSuggested, borderItem).getLocation();
            }
            default: {
                throw new IllegalArgumentException("unsupported side: " + side);
            }
        }
        Point result = this.getAbsoluteToBorder(relativeItem);
        return result;
    }

    protected boolean isOnDestructionOccurrence() {
        return this.getParentFigure() instanceof DestructionEventNodePlate;
    }

    protected Rectangle getLifelineHead() {
        LifelineFigure lifeline = (LifelineFigure)((Object)this.getParentFigure().getChildren().get(0));
        return lifeline.getHeaderFigure().getBounds();
    }

    protected IFigure getParentFigure() {
        return this.parentFigure;
    }

    protected void setParentFigure(IFigure parentFigure) {
        this.parentFigure = parentFigure;
    }

    protected final Dimension getSize(IFigure borderItem) {
        Dimension size = this.getConstraint().getSize();
        if (size.isEmpty()) {
            size = borderItem.getPreferredSize();
        }
        return size;
    }

    protected Point getPreferredLocation(IFigure borderItem) {
        Point constraintLocation = this.locateOnBorder(this.getConstraint(), borderItem);
        return constraintLocation;
    }

    protected Point getAbsoluteToBorder(Point ptRelativeOffset) {
        Point parentOrigin = this.getParentBorder().getTopLeft();
        return parentOrigin.translate(ptRelativeOffset);
    }

    protected Rectangle getParentBorder() {
        Rectangle bounds = this.getParentFigure().getBounds().getCopy();
        if (this.getParentFigure() instanceof NodeFigure) {
            bounds = ((NodeFigure)this.getParentFigure()).getHandleBounds().getCopy();
        }
        return bounds;
    }

    public static <T extends NamedElement> Optional<T> getTimedElement(EditPart timeElementEP, Class<T> type) {
        return Optional.ofNullable((EObject)timeElementEP.getAdapter(EObject.class)).filter(NamedElement.class::isInstance).map(NamedElement.class::cast).flatMap(named -> TimeElementLocator.getTimedElement(named, type));
    }

    public static <T extends NamedElement> Optional<T> getTimedElement(NamedElement timeElement, Class<T> type) {
        Stream<Object> timed = Stream.empty();
        if (timeElement instanceof TimeConstraint) {
            TimeConstraint constraint = (TimeConstraint)timeElement;
            timed = constraint.getConstrainedElements().stream().filter(type::isInstance).map(type::cast);
        } else if (timeElement instanceof TimeObservation) {
            TimeObservation observation = (TimeObservation)timeElement;
            timed = Stream.of(observation.getEvent()).filter(type::isInstance).map(type::cast);
        }
        return timed.findFirst();
    }
}

