/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.config;

import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupModel;
import org.eclipse.nebula.widgets.nattable.group.action.ColumnGroupExpandCollapseAction;
import org.eclipse.nebula.widgets.nattable.group.action.ColumnGroupHeaderReorderDragMode;
import org.eclipse.nebula.widgets.nattable.group.action.ColumnHeaderReorderDragMode;
import org.eclipse.nebula.widgets.nattable.group.action.CreateColumnGroupAction;
import org.eclipse.nebula.widgets.nattable.group.action.UngroupColumnsAction;
import org.eclipse.nebula.widgets.nattable.group.painter.ColumnGroupHeaderTextPainter;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.BeveledBorderDecorator;
import org.eclipse.nebula.widgets.nattable.ui.action.AggregateDragMode;
import org.eclipse.nebula.widgets.nattable.ui.action.CellDragMode;
import org.eclipse.nebula.widgets.nattable.ui.action.NoOpMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.KeyEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.swt.SWT;

public class DefaultColumnGroupHeaderLayerConfiguration
implements IConfiguration {
    public static final String GROUP_COLLAPSED_CONFIG_TYPE = "GROUP_COLLAPSED";
    public static final String GROUP_EXPANDED_CONFIG_TYPE = "GROUP_EXPANDED";
    private final ColumnGroupModel columnGroupModel;

    public DefaultColumnGroupHeaderLayerConfiguration(ColumnGroupModel columnGroupModel) {
        this.columnGroupModel = columnGroupModel;
    }

    @Override
    public void configureLayer(ILayer layer) {
    }

    @Override
    public void configureRegistry(IConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, new BeveledBorderDecorator(new ColumnGroupHeaderTextPainter()), "NORMAL", "COLUMN_GROUP_HEADER");
    }

    @Override
    public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
        uiBindingRegistry.registerMouseDragMode(MouseEventMatcher.columnGroupHeaderLeftClick(0), new AggregateDragMode(new CellDragMode(), new ColumnGroupHeaderReorderDragMode(this.columnGroupModel)));
        uiBindingRegistry.registerMouseDragMode(MouseEventMatcher.columnHeaderLeftClick(0), new ColumnHeaderReorderDragMode(this.columnGroupModel));
        uiBindingRegistry.registerFirstSingleClickBinding(MouseEventMatcher.columnGroupHeaderLeftClick(0), new NoOpMouseAction());
        uiBindingRegistry.registerDoubleClickBinding(MouseEventMatcher.columnGroupHeaderLeftClick(0), new ColumnGroupExpandCollapseAction());
        uiBindingRegistry.registerKeyBinding(new KeyEventMatcher(SWT.MOD1, 103), new CreateColumnGroupAction());
        uiBindingRegistry.registerKeyBinding(new KeyEventMatcher(SWT.MOD1, 117), new UngroupColumnsAction());
    }
}

