/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.outline;

import java.util.ArrayList;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.outline.SymbolsModel;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class CNFOutlinePage
implements IContentOutlinePage,
ILabelProviderListener {
    public static final String ID = "org.eclipse.lsp4e.outline";
    public static final String LINK_WITH_EDITOR_PREFERENCE = "org.eclipse.lsp4e.outline.linkWithEditor";
    public static final String SHOW_KIND_PREFERENCE = "org.eclipse.lsp4e.outline.showKind";
    private CommonViewer outlineViewer;
    private final IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.lsp4e");
    private final ITextEditor textEditor;
    private final ITextViewer textEditorViewer;
    private final IDocument document;
    private final LanguageServer languageServer;
    private EditorSelectionChangedListener editorSelectionChangedListener;

    public CNFOutlinePage(LanguageServer languageServer, @Nullable ITextEditor textEditor) {
        this.textEditor = textEditor;
        this.textEditorViewer = textEditor != null ? (ITextViewer)textEditor.getAdapter(ITextOperationTarget.class) : null;
        this.document = LSPEclipseUtils.getDocument(textEditor);
        this.languageServer = languageServer;
    }

    public void createControl(Composite parent) {
        this.outlineViewer = new CommonViewer(ID, parent, 0);
        this.outlineViewer.setInput((Object)new OutlineInfo(this.document, this.languageServer, this.textEditor));
        this.outlineViewer.getLabelProvider().addListener((ILabelProviderListener)this);
        if (this.textEditor != null) {
            this.outlineViewer.addOpenListener(event -> {
                if (this.preferences.getBoolean(LINK_WITH_EDITOR_PREFERENCE, true)) {
                    this.textEditor.setFocus();
                }
            });
            this.outlineViewer.addSelectionChangedListener(event -> {
                Object selection;
                Range range;
                if (this.preferences.getBoolean(LINK_WITH_EDITOR_PREFERENCE, true) && this.outlineViewer.getTree().isFocusControl() && this.outlineViewer.getSelection() != null && (range = this.getRangeSelection(selection = ((TreeSelection)this.outlineViewer.getSelection()).getFirstElement())) != null) {
                    try {
                        int startOffset = this.document.getLineOffset(range.getStart().getLine()) + range.getStart().getCharacter();
                        int endOffset = this.document.getLineOffset(range.getEnd().getLine()) + range.getEnd().getCharacter();
                        this.textEditor.selectAndReveal(startOffset, endOffset - startOffset);
                    }
                    catch (BadLocationException e) {
                        return;
                    }
                }
            });
            if (this.textEditorViewer != null) {
                this.editorSelectionChangedListener = new EditorSelectionChangedListener();
                this.editorSelectionChangedListener.install(this.textEditorViewer.getSelectionProvider());
            }
        }
    }

    private Range getRangeSelection(Object selection) {
        if (selection == null) {
            return null;
        }
        if (selection instanceof SymbolInformation) {
            return ((SymbolInformation)selection).getLocation().getRange();
        }
        if (selection instanceof SymbolsModel.DocumentSymbolWithFile) {
            return ((SymbolsModel.DocumentSymbolWithFile)selection).symbol.getSelectionRange();
        }
        return null;
    }

    public static void refreshTreeSelection(TreeViewer viewer, int offset, IDocument document) {
        ITreeContentProvider contentProvider = (ITreeContentProvider)viewer.getContentProvider();
        Object[] objects = contentProvider.getElements(null);
        ArrayList<Object> path = new ArrayList<Object>();
        while (objects != null && objects.length > 0) {
            boolean found = false;
            int index = 0;
            while (index < objects.length) {
                Object object = objects[index];
                Range range = CNFOutlinePage.toRange(object);
                if (range != null && CNFOutlinePage.isOffsetInRange(offset, range, document)) {
                    objects = contentProvider.getChildren(object);
                    path.add(object);
                    found = true;
                    break;
                }
                ++index;
            }
            if (found) continue;
            objects = null;
        }
        if (!path.isEmpty()) {
            Object bestNode = path.get(path.size() - 1);
            if (bestNode.equals(viewer.getStructuredSelection().getFirstElement())) {
                return;
            }
            Display.getDefault().asyncExec(() -> {
                TreePath treePath = new TreePath(path.toArray());
                viewer.reveal((Object)treePath);
                viewer.setSelection((ISelection)new TreeSelection(treePath), true);
            });
        }
    }

    private static Range toRange(Object object) {
        SymbolInformation symbol;
        Range range = null;
        SymbolInformation symbolInformation = symbol = object instanceof SymbolInformation ? (SymbolInformation)object : (SymbolInformation)Adapters.adapt((Object)object, SymbolInformation.class);
        if (symbol != null) {
            range = symbol.getLocation().getRange();
        } else {
            SymbolsModel.DocumentSymbolWithFile documentSymbol;
            SymbolsModel.DocumentSymbolWithFile documentSymbolWithFile = documentSymbol = object instanceof SymbolsModel.DocumentSymbolWithFile ? (SymbolsModel.DocumentSymbolWithFile)object : (SymbolsModel.DocumentSymbolWithFile)Adapters.adapt((Object)object, SymbolsModel.DocumentSymbolWithFile.class);
            if (documentSymbol != null) {
                range = documentSymbol.symbol.getRange();
            }
        }
        return range;
    }

    private static boolean isOffsetInRange(int offset, Range range, IDocument document) {
        try {
            int startOffset = document.getLineOffset(range.getStart().getLine()) + range.getStart().getCharacter();
            int endOffset = document.getLineOffset(range.getEnd().getLine()) + range.getEnd().getCharacter();
            return startOffset <= offset && endOffset >= offset;
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    public void dispose() {
        this.outlineViewer.dispose();
        if (this.textEditorViewer != null) {
            this.editorSelectionChangedListener.uninstall(this.textEditorViewer.getSelectionProvider());
        }
    }

    public Control getControl() {
        return this.outlineViewer.getControl();
    }

    public void setActionBars(IActionBars actionBars) {
    }

    public void setFocus() {
        this.outlineViewer.getTree().setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.outlineViewer.addSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        return this.outlineViewer.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.outlineViewer.removeSelectionChangedListener(listener);
    }

    public void setSelection(ISelection selection) {
        this.outlineViewer.setSelection(selection);
    }

    public void labelProviderChanged(LabelProviderChangedEvent event) {
        this.outlineViewer.refresh(true);
    }

    class EditorSelectionChangedListener
    implements ISelectionChangedListener {
        EditorSelectionChangedListener() {
        }

        public void install(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.addPostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void uninstall(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.removePostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = event.getSelection();
            if (!(selection instanceof ITextSelection)) {
                return;
            }
            ITextSelection textSelection = (ITextSelection)selection;
            if (!CNFOutlinePage.this.preferences.getBoolean(CNFOutlinePage.LINK_WITH_EDITOR_PREFERENCE, true)) {
                return;
            }
            int offset = CNFOutlinePage.this.outlineViewer instanceof ITextViewerExtension5 ? ((ITextViewerExtension5)CNFOutlinePage.this.outlineViewer).widgetOffset2ModelOffset(textSelection.getOffset()) : textSelection.getOffset();
            CNFOutlinePage.refreshTreeSelection((TreeViewer)CNFOutlinePage.this.outlineViewer, offset, CNFOutlinePage.this.document);
        }
    }

    class OutlineInfo {
        public final ITextEditor textEditor;
        public final LanguageServer languageServer;
        public final IDocument document;

        public OutlineInfo(IDocument document, @Nullable LanguageServer languageServer, ITextEditor textEditor) {
            this.document = document;
            this.languageServer = languageServer;
            this.textEditor = textEditor;
        }
    }
}

