/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.charts.actions;

import java.io.File;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.internal.dataviewers.charts.Activator;
import org.eclipse.linuxtools.internal.dataviewers.charts.Messages;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.swtchart.Chart;

@Deprecated
public class SaveChartAction
extends Action {
    private static final String[] EXTENSIONS = new String[]{"*.png", "*.bmp", "*.jpg", "*.jpeg", "*.*"};
    private static final String DEFAULT_EXT = "png";
    private static final String DEFAULT_TITLE = "newChart";
    private static final Map<String, Integer> EXTENSION_MAP = new HashMap<String, Integer>();
    private Composite contents = null;
    private String title = null;

    static {
        EXTENSION_MAP.put(DEFAULT_EXT, 5);
        EXTENSION_MAP.put("bmp", 0);
        EXTENSION_MAP.put("jpeg", 4);
        EXTENSION_MAP.put("jpg", 4);
    }

    public SaveChartAction() {
        super(Messages.ChartConstants_SAVE_CHART_AS, Activator.getImageDescriptor("icons/chart-save.png"));
        this.setEnabled(false);
    }

    public void setChart(Composite contents) {
        this.setChart(contents, null);
    }

    public void setChart(Composite contents, String title) {
        this.contents = contents;
        if (contents != null) {
            this.title = title != null ? title : this.getDefaultName();
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    private String getDefaultName() {
        if (this.contents instanceof Chart) {
            return ((Chart)this.contents).getTitle().getText().replaceAll(" ", "_");
        }
        return DEFAULT_TITLE;
    }

    public void run() {
        if (this.problemExists()) {
            return;
        }
        File file = this.askForAndPrepareFile();
        if (file == null) {
            return;
        }
        this.generateImageFile(file);
    }

    public void run(String path) {
        if (this.problemExists()) {
            return;
        }
        File file = new File(this.makePathWithVerifiedExt(path));
        if (this.shouldOverwrite(file, null)) {
            this.generateImageFile(new File(path));
        }
    }

    private boolean problemExists() {
        Status status = null;
        if (!this.isEnabled()) {
            status = new Status(4, "org.eclipse.linuxtools.dataviewers.charts", Messages.ChartConstants_ERROR_CHART_CLOSED);
        } else if (this.contents.isDisposed()) {
            status = new Status(4, "org.eclipse.linuxtools.dataviewers.charts", Messages.ChartConstants_ERROR_CHART_DISPOSED);
        }
        if (status != null) {
            ErrorDialog.openError((Shell)this.getWorkbenchShell(), (String)Messages.ChartConstants_ERROR_SAVING_CHART, (String)Messages.ChartConstants_ERROR_SAVING_CHART_MESSAGE, (IStatus)status);
            return true;
        }
        return false;
    }

    private File askForAndPrepareFile() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        FileDialog dialog = new FileDialog(shell, 8192);
        dialog.setFilterExtensions(EXTENSIONS);
        dialog.setText(Messages.ChartConstants_SAVE_CHART_DIALOG_TEXT);
        dialog.setFileName(this.title);
        String path;
        while ((path = dialog.open()) != null) {
            File file = new File(path = this.makePathWithVerifiedExt(path));
            if (this.shouldOverwrite(file, shell)) {
                return file;
            }
            dialog.setFileName(file.getName());
        }
        return null;
    }

    private boolean shouldOverwrite(File file, Shell shell) {
        if (!file.exists()) {
            return true;
        }
        if (MessageDialog.openQuestion((Shell)(shell != null ? shell : PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()), (String)Messages.ChartConstants_CONFIRM_OVERWRITE_TITLE, (String)MessageFormat.format(Messages.ChartConstants_CONFIRM_OVERWRITE_MSG, file))) {
            file.delete();
            return true;
        }
        return false;
    }

    private String makePathWithVerifiedExt(String path) {
        String pathExt = Path.fromOSString((String)path).getFileExtension();
        if (pathExt == null) {
            return path.concat(".png");
        }
        if (EXTENSION_MAP.containsKey(pathExt)) {
            return path;
        }
        return path.replaceAll(pathExt.concat("$"), DEFAULT_EXT);
    }

    private void generateImageFile(File file) {
        int extension = EXTENSION_MAP.get(Path.fromOSString((String)file.getName()).getFileExtension());
        Display dsp = Display.getCurrent();
        GC gc = new GC((Drawable)this.contents);
        Image img = new Image((Device)dsp, this.contents.getSize().x, this.contents.getSize().y);
        gc.copyArea(img, 0, 0);
        gc.dispose();
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[]{img.getImageData()};
        imageLoader.save(file.getAbsolutePath(), extension);
    }

    private Shell getWorkbenchShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }
}

