/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;

public class UnwrapNewArrayOperation
extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
    private final ArrayCreation node;
    private final ASTNode call;

    public UnwrapNewArrayOperation(ArrayCreation node, MethodInvocation method) {
        this.node = node;
        this.call = method;
    }

    public UnwrapNewArrayOperation(ArrayCreation node, SuperMethodInvocation superMethod) {
        this.node = node;
        this.call = superMethod;
    }

    @Override
    public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
        ASTRewrite rewrite = cuRewrite.getASTRewrite();
        AST ast = cuRewrite.getRoot().getAST();
        if (this.call instanceof MethodInvocation) {
            MethodInvocation method = (MethodInvocation)this.call;
            MethodInvocation newMethod = ast.newMethodInvocation();
            newMethod.setSourceRange(method.getStartPosition(), method.getLength());
            newMethod.setName(ast.newSimpleName(method.getName().getFullyQualifiedName()));
            newMethod.setExpression(ASTNodes.copySubtree(ast, method.getExpression()));
            if (method.typeArguments() != null) {
                List createMoveTarget = ASTNodes.createMoveTarget(rewrite, method.typeArguments());
                newMethod.typeArguments().addAll(createMoveTarget);
            }
            int i = 0;
            while (i < method.arguments().size() - 1) {
                newMethod.arguments().add(ASTNodes.createMoveTarget(rewrite, (Expression)method.arguments().get(i)));
                ++i;
            }
            ArrayInitializer initializer = this.node.getInitializer();
            if (initializer != null && initializer.expressions() != null) {
                for (Object exp : initializer.expressions()) {
                    newMethod.arguments().add(ASTNodes.createMoveTarget(rewrite, (Expression)exp));
                }
            }
            rewrite.replace((ASTNode)method, (ASTNode)newMethod, null);
        } else if (this.call instanceof SuperMethodInvocation) {
            SuperMethodInvocation method = (SuperMethodInvocation)this.call;
            SuperMethodInvocation newSuperMethod = ast.newSuperMethodInvocation();
            newSuperMethod.setSourceRange(method.getStartPosition(), method.getLength());
            newSuperMethod.setName(ast.newSimpleName(method.getName().getFullyQualifiedName()));
            if (method.typeArguments() != null) {
                List createMoveTarget = ASTNodes.createMoveTarget(rewrite, method.typeArguments());
                newSuperMethod.typeArguments().addAll(createMoveTarget);
            }
            int i = 0;
            while (i < method.arguments().size() - 1) {
                newSuperMethod.arguments().add(ASTNodes.createMoveTarget(rewrite, (Expression)method.arguments().get(i)));
                ++i;
            }
            ArrayInitializer initializer = this.node.getInitializer();
            if (initializer != null && initializer.expressions() != null) {
                for (Object exp : initializer.expressions()) {
                    newSuperMethod.arguments().add(ASTNodes.createMoveTarget(rewrite, (Expression)exp));
                }
            }
            rewrite.replace((ASTNode)method, (ASTNode)newSuperMethod, null);
        }
    }
}

