/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.object;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import org.eclipse.emf.cdo.CDOObjectHistory;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.id.CDOIdentifiable;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.common.revision.CDOElementProxy;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionData;
import org.eclipse.emf.cdo.common.security.CDOPermission;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.impl.CDOResourceImpl;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOClassInfo;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.internal.cdo.CDOObjectImpl;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.object.CDOObjectWrapper;
import org.eclipse.emf.internal.cdo.view.CDOStateMachine;
import org.eclipse.emf.spi.cdo.CDOStore;
import org.eclipse.emf.spi.cdo.FSMUtil;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOResource;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public abstract class CDOLegacyWrapper
extends CDOObjectWrapper {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_OBJECT, CDOLegacyWrapper.class);
    private final InternalCDOClassInfo classInfo;
    private static ThreadLocal<Map<CDOID, CDOLegacyWrapper>> wrapperRegistry = new InheritableThreadLocal<Map<CDOID, CDOLegacyWrapper>>();
    private static ThreadLocal<Counter> recursionCounter = new InheritableThreadLocal<Counter>();
    protected InternalCDOView.ViewAndState viewAndState;
    protected Object idOrRevision;
    private boolean underConstruction;

    public CDOLegacyWrapper(InternalEObject instance) {
        this.instance = instance;
        this.classInfo = (InternalCDOClassInfo)CDOModelUtil.getClassInfo((EClass)instance.eClass());
        this.viewAndState = InternalCDOView.ViewAndState.TRANSIENT;
    }

    @Override
    public InternalCDOClassInfo cdoClassInfo() {
        return this.classInfo;
    }

    @Override
    public CDOID cdoID() {
        if (this.idOrRevision == null) {
            return null;
        }
        if (this.idOrRevision instanceof CDOID) {
            return (CDOID)this.idOrRevision;
        }
        return ((InternalCDORevision)this.idOrRevision).getID();
    }

    @Override
    public InternalCDOView cdoView() {
        return this.viewAndState.view;
    }

    @Override
    public void cdoInternalSetID(CDOID id) {
        if (TRACER.isEnabled()) {
            TRACER.format("Setting ID: {0} for {1}", new Object[]{id, this.instance});
        }
        if (this.idOrRevision == null || id == null) {
            this.idOrRevision = id;
        }
    }

    @Override
    public void cdoInternalSetView(CDOView view) {
        InternalCDOView newView;
        if (TRACER.isEnabled()) {
            TRACER.format("Setting view: {0} for {1}", new Object[]{view, this.instance});
        }
        this.viewAndState = (newView = (InternalCDOView)view) != null ? newView.getViewAndState(this.viewAndState.state) : InternalCDOView.ViewAndState.TRANSIENT.getViewAndState(this.viewAndState.state);
    }

    @Override
    public CDOState cdoState() {
        return this.viewAndState.state;
    }

    @Override
    public InternalCDORevision cdoRevision() {
        if (this.idOrRevision instanceof InternalCDORevision) {
            return (InternalCDORevision)this.idOrRevision;
        }
        return null;
    }

    @Override
    public InternalCDORevision cdoRevision(boolean loadOnDemand) {
        if (loadOnDemand) {
            CDOStateMachine.INSTANCE.read(this);
        }
        return this.cdoRevision();
    }

    @Override
    public CDOPermission cdoPermission() {
        InternalCDORevision revision = this.cdoRevision(true);
        if (revision == null) {
            return CDOPermission.WRITE;
        }
        return revision.getPermission();
    }

    @Override
    public CDOResourceImpl cdoResource() {
        this.revisionToInstanceResource();
        return super.cdoResource();
    }

    @Override
    @Deprecated
    public void cdoReload() {
        CDOStateMachine.INSTANCE.reload(this);
    }

    @Override
    public CDOObjectHistory cdoHistory() {
        return (CDOObjectHistory)this.viewAndState.view.getHistory(this);
    }

    @Override
    public CDOState cdoInternalSetState(CDOState state) {
        CDOState oldState = this.viewAndState.state;
        if (oldState != state) {
            if (TRACER.isEnabled()) {
                TRACER.format("Setting state {0} for {1}", new Object[]{state, this});
            }
            this.viewAndState = this.viewAndState.getViewAndState(state);
            this.adjustEProxy();
            if (this.viewAndState.view != null) {
                this.viewAndState.view.handleObjectStateChanged(this, oldState, state);
            }
            return oldState;
        }
        return null;
    }

    @Override
    public void cdoInternalSetRevision(CDORevision revision) {
        if (TRACER.isEnabled()) {
            TRACER.trace("Setting revision: " + revision);
        }
        this.idOrRevision = revision == null ? this.cdoID() : revision;
    }

    @Override
    public void cdoInternalPreAttach() {
    }

    @Override
    public void cdoInternalPostAttach() {
        this.instanceToRevision();
        for (Adapter adapter : this.eAdapters()) {
            if (adapter instanceof CDOObjectWrapper) continue;
            this.viewAndState.view.handleAddAdapter(this, adapter);
        }
    }

    @Override
    public void cdoInternalPostDetach(boolean remote) {
        if (remote) {
            this.setInstanceContainer(null, this.eContainerFeatureID());
            this.setInstanceResource(null);
            return;
        }
        InternalCDORevision revision = this.cdoRevision();
        EReference[] eReferenceArray = this.classInfo.getAllPersistentReferences();
        int n = eReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            EReference reference = eReferenceArray[n2];
            if (!reference.isContainer() && this.classInfo.hasPersistentOpposite((EStructuralFeature)reference)) {
                if (reference.isMany()) {
                    EReference oppositeReference = reference.getEOpposite();
                    int size = revision.size((EStructuralFeature)reference);
                    int i = 0;
                    while (i < size) {
                        EObject object = (EObject)this.getValueFromRevision((EStructuralFeature)reference, i);
                        this.adjustPersistentOppositeReference(this, object, oppositeReference);
                        ++i;
                    }
                } else {
                    EObject oppositeObject = (EObject)this.instance.eGet((EStructuralFeature)reference);
                    if (oppositeObject != null) {
                        EReference oppositeReference = reference.getEOpposite();
                        this.adjustPersistentOppositeReference(this, oppositeObject, oppositeReference);
                    }
                }
            }
            ++n2;
        }
    }

    @Override
    public void cdoInternalPostRollback() {
        CDOStateMachine.INSTANCE.read(this);
    }

    @Override
    public void cdoInternalPreCommit() {
        this.instanceToRevisionContainment();
        InternalCDORevision revision = this.cdoRevision();
        EStructuralFeature[] eStructuralFeatureArray = this.classInfo.getAllPersistentFeatures();
        int n = eStructuralFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature feature = eStructuralFeatureArray[n2];
            if (feature.isUnsettable()) {
                if (!this.isSetInstanceValue(this.instance, feature)) {
                    if (feature.isMany()) {
                        InternalEList list = (InternalEList)this.instance.eGet(feature);
                        this.clearEList(list);
                    } else {
                        revision.set(feature, -1, null);
                    }
                } else if (this.instance.eGet(feature) == null) {
                    revision.set(feature, -1, CDORevisionData.NIL);
                }
            }
            ++n2;
        }
    }

    @Override
    public void cdoInternalPreLoad() {
    }

    @Override
    public void cdoInternalPostLoad() {
        this.revisionToInstance();
    }

    @Override
    public void cdoInternalPostInvalidate() {
        if (this.cdoState() != CDOState.PROXY) {
            throw new IllegalStateException();
        }
        InternalCDORevision revision = this.cdoView().getRevision(this.cdoID(), true);
        if (revision == null) {
            this.cdoInternalPostDetach(true);
        } else {
            this.cdoInternalSetRevision((CDORevision)revision);
            this.revisionToInstance();
            this.cdoInternalSetState(CDOState.CLEAN);
        }
    }

    @Override
    public void cdoInternalRollback(InternalCDORevision revision) {
        this.cdoInternalSetRevision((CDORevision)revision);
        boolean bypassPermissionChecks = revision.bypassPermissionChecks(true);
        boolean deliver = this.instance.eDeliver();
        if (deliver) {
            this.instance.eSetDeliver(false);
        }
        try {
            EStructuralFeature[] eStructuralFeatureArray = this.classInfo.getAllPersistentFeatures();
            int n = eStructuralFeatureArray.length;
            int n2 = 0;
            while (n2 < n) {
                EStructuralFeature feature = eStructuralFeatureArray[n2];
                this.revisionToInstanceFeature(feature);
                ++n2;
            }
        }
        finally {
            revision.bypassPermissionChecks(bypassPermissionChecks);
            if (deliver) {
                this.instance.eSetDeliver(true);
            }
        }
    }

    protected void instanceToRevision() {
        InternalCDORevision revision = this.cdoRevision();
        if (TRACER.isEnabled()) {
            TRACER.format("Transfering instance to revision: {0} --> {1}", new Object[]{this.instance, revision});
        }
        this.instanceToRevisionContainment();
        EStructuralFeature[] eStructuralFeatureArray = this.classInfo.getAllPersistentFeatures();
        int n = eStructuralFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature feature = eStructuralFeatureArray[n2];
            this.instanceToRevisionFeature(feature);
            ++n2;
        }
        revision.setUnchunked();
    }

    protected void instanceToRevisionContainment() {
        InternalCDORevision revision = this.cdoRevision();
        CDOResource resource = (CDOResource)this.getInstanceResource(this.instance);
        revision.setResourceID(resource == null ? CDOID.NULL : resource.cdoID());
        InternalEObject eContainer = this.getInstanceContainer(this.instance);
        if (eContainer == null) {
            revision.setContainerID((Object)CDOID.NULL);
            revision.setContainingFeatureID(0);
        } else {
            InternalCDOObject cdoContainer = FSMUtil.adapt(eContainer, this.viewAndState.view);
            revision.setContainerID((Object)cdoContainer);
            revision.setContainingFeatureID(this.getInstanceContainerFeatureID(this.instance));
        }
    }

    protected void instanceToRevisionFeature(EStructuralFeature feature) {
        if (this.isSetInstanceValue(this.instance, feature)) {
            Object instanceValue = this.getInstanceValue(this.instance, feature);
            CDOObjectImpl.instanceToRevisionFeature(this.viewAndState.view, this, feature, instanceValue);
        }
    }

    protected void revisionToInstance() {
        Counter counter;
        boolean deliver;
        if (this.underConstruction) {
            return;
        }
        this.underConstruction = true;
        InternalCDORevision revision = this.cdoRevision();
        if (TRACER.isEnabled()) {
            TRACER.format("Transfering revision to instance: {0} --> {1}", new Object[]{revision, this.instance});
        }
        if (deliver = this.instance.eDeliver()) {
            this.instance.eSetDeliver(false);
        }
        if ((counter = recursionCounter.get()) == null) {
            counter = new Counter();
            recursionCounter.set(counter);
        }
        InternalCDOResource resource = null;
        boolean bypassPermissionChecks = revision.bypassPermissionChecks(true);
        try {
            try {
                CDOLegacyWrapper.registerWrapper(this);
                counter.increment();
                this.viewAndState.view.registerObject(this);
                this.revisionToInstanceResource();
                this.revisionToInstanceContainer();
                Resource eResource = this.instance.eResource();
                if (eResource instanceof InternalCDOResource) {
                    resource = (InternalCDOResource)eResource;
                    resource.cdoInternalLoading((EObject)this.instance);
                }
                EStructuralFeature[] eStructuralFeatureArray = this.classInfo.getAllPersistentFeatures();
                int n = eStructuralFeatureArray.length;
                int n2 = 0;
                while (n2 < n) {
                    EStructuralFeature feature = eStructuralFeatureArray[n2];
                    this.revisionToInstanceFeature(feature);
                    ++n2;
                }
            }
            catch (RuntimeException ex) {
                OM.LOG.error((Throwable)ex);
                throw ex;
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
                throw new CDOException((Throwable)ex);
            }
        }
        finally {
            try {
                revision.bypassPermissionChecks(bypassPermissionChecks);
                if (resource != null) {
                    resource.cdoInternalLoadingDone((EObject)this.instance);
                }
                if (deliver) {
                    this.instance.eSetDeliver(true);
                }
            }
            finally {
                if (counter.decrement() == 0) {
                    recursionCounter.remove();
                }
                CDOLegacyWrapper.unregisterWrapper(this);
                this.underConstruction = false;
            }
        }
    }

    protected void revisionToInstanceContainer() {
        InternalCDORevision revision = this.cdoRevision();
        CDOPermission permission = revision.getPermission();
        if (permission != CDOPermission.WRITE) {
            revision.setPermission(CDOPermission.WRITE);
        }
        try {
            Object containerID = revision.getContainerID();
            InternalEObject container = this.getEObjectFromPotentialID(this.viewAndState.view, null, containerID);
            EObject oldContainer = this.instance.eContainer();
            if (oldContainer != container) {
                this.setInstanceContainer(container, revision.getContainingFeatureID());
            }
        }
        finally {
            if (permission != CDOPermission.WRITE) {
                revision.setPermission(permission);
            }
        }
    }

    protected void revisionToInstanceResource() {
        CDOID resourceID;
        InternalCDORevision revision = this.cdoRevision();
        if (revision != null && !CDOIDUtil.isNull((CDOID)(resourceID = revision.getResourceID()))) {
            InternalEObject resource = this.getEObjectFromPotentialID(this.viewAndState.view, null, resourceID);
            this.setInstanceResource((Resource.Internal)resource);
            if (resource != null) {
                this.viewAndState.view.registerObject((InternalCDOObject)resource);
            }
        }
    }

    protected void revisionToInstanceFeature(EStructuralFeature feature) {
        boolean isSet = true;
        if (feature.isUnsettable() && !(isSet = this.viewAndState.view.getStore().isSet(this, feature))) {
            this.instance.eUnset(feature);
            return;
        }
        if (feature.isMany()) {
            if (TRACER.isEnabled()) {
                TRACER.format("State of Object (" + this + "/" + this.instance + ") is : " + (Object)((Object)this.viewAndState.state), new Object[0]);
            }
            if (this.viewAndState.state == CDOState.CLEAN || this.viewAndState.state == CDOState.PROXY || this.viewAndState.state == CDOState.NEW || this.viewAndState.state == CDOState.DIRTY) {
                InternalCDORevision revision = this.cdoRevision();
                int size = revision.size(feature);
                InternalEList list = (InternalEList)this.instance.eGet(feature);
                this.clearEList(list);
                if (size == 0 && feature.isUnsettable() && isSet) {
                    list.clear();
                }
                int i = 0;
                while (i < size) {
                    Notifier notifier;
                    Object object = this.getValueFromRevision(feature, i);
                    if (TRACER.isEnabled()) {
                        TRACER.format("Adding " + object + " to feature " + feature + "in instance " + this.instance, new Object[0]);
                    }
                    boolean eDeliver = false;
                    if (object instanceof Notifier && (eDeliver = (notifier = (Notifier)object).eDeliver())) {
                        notifier.eSetDeliver(false);
                    }
                    list.basicAdd(object, null);
                    if (object instanceof Notifier && eDeliver) {
                        notifier = (Notifier)object;
                        notifier.eSetDeliver(eDeliver);
                    }
                    ++i;
                }
            }
        } else {
            Object object = this.getValueFromRevision(feature, 0);
            if (feature instanceof EAttribute) {
                if (TRACER.isEnabled()) {
                    TRACER.format("Setting attribute value " + object + " to feature " + feature + " in instance " + this.instance, new Object[0]);
                }
                if (feature.isUnsettable() && object.equals(CDORevisionData.NIL)) {
                    this.eSet(feature, null);
                } else if (object != null) {
                    this.eSet(feature, object);
                } else {
                    this.eUnset(feature);
                }
            } else {
                InternalEObject eObject;
                Notifier notifier;
                if (TRACER.isEnabled()) {
                    TRACER.format("Adding object " + object + " to feature " + feature + " in instance " + this.instance, new Object[0]);
                }
                boolean eDeliver = false;
                if (object instanceof Notifier && (eDeliver = (notifier = (Notifier)object).eDeliver())) {
                    notifier.eSetDeliver(false);
                }
                InternalEObject oldContainerOfValue = null;
                boolean eDeliverForOldContainerOfValue = false;
                if (object instanceof InternalEObject && (oldContainerOfValue = (eObject = (InternalEObject)object).eInternalContainer()) != null && (eDeliverForOldContainerOfValue = oldContainerOfValue.eDeliver())) {
                    oldContainerOfValue.eSetDeliver(false);
                }
                int featureID = this.instance.eClass().getFeatureID(feature);
                Class<?> baseClass = object == null ? null : object.getClass();
                EStructuralFeature.Internal internalFeature = (EStructuralFeature.Internal)feature;
                EReference oppositeReference = internalFeature.getEOpposite();
                if (oppositeReference != null) {
                    if (object != null && object != this.instance.eGet(feature)) {
                        if (object != this.instance.eContainer() || !oppositeReference.isContainment()) {
                            this.instance.eInverseAdd((InternalEObject)object, featureID, baseClass, null);
                        }
                        if (!this.classInfo.hasPersistentOpposite((EStructuralFeature)internalFeature)) {
                            this.adjustTransientOppositeReference(this.instance, (InternalEObject)object, oppositeReference);
                        }
                    }
                } else if (object != CDORevisionData.NIL) {
                    EReference reference = (EReference)feature;
                    if (reference.isContainment()) {
                        if (object != null) {
                            this.instance.eSet(feature, object);
                        } else {
                            this.instance.eSet(feature, null);
                        }
                    } else {
                        this.instance.eSet(feature, object);
                    }
                } else {
                    this.instance.eSet(feature, null);
                }
                if (object instanceof Notifier && eDeliver) {
                    Notifier notifier2 = (Notifier)object;
                    notifier2.eSetDeliver(eDeliver);
                }
                if (oldContainerOfValue != null && eDeliverForOldContainerOfValue) {
                    oldContainerOfValue.eSetDeliver(eDeliverForOldContainerOfValue);
                }
                if (TRACER.isEnabled()) {
                    TRACER.format("Added object " + object + " to feature " + feature + " in instance " + this.instance, new Object[0]);
                }
            }
        }
    }

    private Object getValueFromRevision(EStructuralFeature feature, int index) {
        InternalCDORevision revision = this.cdoRevision();
        Object object = revision.get(feature, index);
        if (object == null) {
            return null;
        }
        if (object instanceof CDOElementProxy) {
            CDOElementProxy proxy = (CDOElementProxy)object;
            object = this.viewAndState.view.getSession().resolveElementProxy((CDORevision)revision, feature, index, proxy.getIndex());
        }
        if (object instanceof CDOLegacyWrapper) {
            return ((CDOLegacyWrapper)object).cdoInternalInstance();
        }
        CDOType type = CDOModelUtil.getType((EClassifier)feature.getEType());
        object = this.viewAndState.view.getStore().convertToEMF((EObject)this.instance, revision, feature, index, object);
        if (type == CDOType.OBJECT && object instanceof CDOID) {
            CDOID id = (CDOID)object;
            if (id.isNull()) {
                return null;
            }
            object = CDOLegacyWrapper.getRegisteredWrapper(id);
            if (object != null) {
                return ((CDOLegacyWrapper)object).cdoInternalInstance();
            }
            object = id.isExternal() ? this.viewAndState.view.getResourceSet().getEObject(URI.createURI((String)id.toURIFragment()), true) : this.viewAndState.view.getObject(id);
            if (object instanceof CDOObjectWrapper) {
                return ((CDOObjectWrapper)object).cdoInternalInstance();
            }
        }
        return object;
    }

    protected InternalEObject getEObjectFromPotentialID(InternalCDOView view, EStructuralFeature feature, Object potentialID) {
        CDOLegacyWrapper wrapper;
        if (potentialID instanceof CDOID && (wrapper = CDOLegacyWrapper.getRegisteredWrapper((CDOID)potentialID)) != null) {
            potentialID = wrapper.instance;
            if (TRACER.isEnabled()) {
                TRACER.format("Getting Object (" + potentialID + ") from localThread instead of the view", new Object[0]);
            }
        } else {
            if (potentialID instanceof CDOID) {
                CDOID id = (CDOID)potentialID;
                if (id.isNull()) {
                    return null;
                }
                if (id.isExternal()) {
                    URI uri = URI.createURI((String)id.toURIFragment());
                    InternalEObject eObject = (InternalEObject)this.viewAndState.view.getResourceSet().getEObject(uri, true);
                    return eObject;
                }
                boolean loadOnDemand = feature == null;
                potentialID = this.viewAndState.view.getObject(id, loadOnDemand);
                if (potentialID == null && !loadOnDemand) {
                    return this.createProxy(view, feature, id);
                }
            }
            if (potentialID instanceof InternalCDOObject) {
                return ((InternalCDOObject)potentialID).cdoInternalInstance();
            }
        }
        return (InternalEObject)potentialID;
    }

    protected InternalEObject createProxy(InternalCDOView view, EStructuralFeature feature, CDOID id) {
        EClassifier eType = feature.getEType();
        Class instanceClass = eType.getInstanceClass();
        Class[] interfaces = new Class[]{instanceClass, InternalEObject.class, LegacyProxy.class};
        ClassLoader classLoader = CDOLegacyWrapper.class.getClassLoader();
        LegacyProxyInvocationHandler handler = new LegacyProxyInvocationHandler(this, id);
        return (InternalEObject)Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)handler);
    }

    protected void clearEList(InternalEList<?> list) {
        int i = list.size() - 1;
        while (i >= 0) {
            Notifier notifier;
            Object obj = list.get(i);
            boolean eDeliver = false;
            if (obj instanceof Notifier && (eDeliver = (notifier = (Notifier)obj).eDeliver())) {
                notifier.eSetDeliver(false);
            }
            list.basicRemove(obj, null);
            if (obj instanceof Notifier && eDeliver) {
                notifier = (Notifier)obj;
                notifier.eSetDeliver(eDeliver);
            }
            --i;
        }
    }

    protected void resolveAllProxies() {
        EStructuralFeature[] eStructuralFeatureArray = this.classInfo.getAllPersistentFeatures();
        int n = eStructuralFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature feature = eStructuralFeatureArray[n2];
            if (feature instanceof EReference) {
                this.resolveProxies(feature);
            }
            ++n2;
        }
    }

    protected void resolveProxies(EStructuralFeature feature) {
        Object value = this.getInstanceValue(this.instance, feature);
        if (value != null) {
            if (feature.isMany()) {
                InternalEList list = (InternalEList)value;
                int size = list.size();
                boolean deliver = this.instance.eDeliver();
                if (deliver) {
                    this.instance.eSetDeliver(false);
                }
                int i = 0;
                while (i < size) {
                    Object element = list.get(i);
                    if (element instanceof LegacyProxy) {
                        CDOID id = ((LegacyProxy)element).getID();
                        InternalCDOObject resolved = (InternalCDOObject)this.viewAndState.view.getObject(id);
                        InternalEObject instance = resolved.cdoInternalInstance();
                        list.set(i, (Object)instance);
                    }
                    ++i;
                }
                if (deliver) {
                    this.instance.eSetDeliver(true);
                }
            } else if (value instanceof LegacyProxy) {
                CDOID id = ((LegacyProxy)value).getID();
                InternalCDOObject resolved = (InternalCDOObject)this.viewAndState.view.getObject(id);
                InternalEObject instance = resolved.cdoInternalInstance();
                this.setInstanceValue(instance, feature, instance);
            }
        }
    }

    protected void adjustEProxy() {
        if (this.viewAndState.state == CDOState.PROXY) {
            if (!this.instance.eIsProxy()) {
                URI uri = URI.createURI((String)("cdo:proxy#" + this.cdoID()));
                if (TRACER.isEnabled()) {
                    TRACER.format("Setting proxyURI {0} for {1}", new Object[]{uri, this.instance});
                }
                this.instance.eSetProxyURI(uri);
            }
        } else if (this.instance.eIsProxy()) {
            if (TRACER.isEnabled()) {
                TRACER.format("Unsetting proxyURI for {0}", new Object[]{this.instance});
            }
            this.instance.eSetProxyURI(null);
        }
    }

    @Override
    public synchronized EList<Adapter> eAdapters() {
        EList<Adapter> adapters = super.eAdapters();
        if (!FSMUtil.isTransient(this)) {
            InternalCDOView view = this.cdoView();
            for (Adapter adapter : adapters) {
                if (adapter instanceof CDOLegacyWrapper) continue;
                view.handleAddAdapter(this, adapter);
            }
        }
        return adapters;
    }

    public static boolean isLegacyProxy(Object object) {
        return object instanceof LegacyProxy;
    }

    protected static int getEFlagMask(Class<?> instanceClass, String flagName) {
        Field field = ReflectUtil.getField(instanceClass, (String)flagName);
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            return (Integer)field.get(null);
        }
        catch (IllegalAccessException ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }

    private static CDOLegacyWrapper getRegisteredWrapper(CDOID id) {
        Map<CDOID, CDOLegacyWrapper> map = wrapperRegistry.get();
        if (map == null) {
            return null;
        }
        return map.get(id);
    }

    private static void registerWrapper(CDOLegacyWrapper wrapper) {
        Map map = wrapperRegistry.get();
        if (map == null) {
            map = CDOIDUtil.createMap();
            wrapperRegistry.set(map);
        }
        map.put(wrapper.cdoID(), wrapper);
    }

    private static void unregisterWrapper(CDOLegacyWrapper wrapper) {
        Map<CDOID, CDOLegacyWrapper> map = wrapperRegistry.get();
        if (map == null) {
            return;
        }
        CDOID id = wrapper.cdoID();
        if (map.remove(id) != null && map.isEmpty()) {
            wrapperRegistry.remove();
        }
    }

    private void adjustPersistentOppositeReference(InternalCDOObject cdoObject, EObject oppositeObject, EReference oppositeReference) {
        CDOStore store;
        InternalCDOView view;
        InternalCDOObject oppositeCDOObject = (InternalCDOObject)CDOUtil.getCDOObject(oppositeObject);
        if (oppositeCDOObject != null && (view = oppositeCDOObject.cdoView()) != null && (store = this.viewAndState.view.getStore()) != null) {
            if (oppositeReference.isMany()) {
                InternalEObject eObject = oppositeCDOObject.cdoInternalInstance();
                EList list = (EList)eObject.eGet((EStructuralFeature)oppositeReference);
                int index = list.indexOf((Object)this.instance);
                if (index != -1 && !store.isEmpty(oppositeCDOObject, (EStructuralFeature)oppositeReference)) {
                    store.set(oppositeCDOObject, (EStructuralFeature)oppositeReference, index, cdoObject);
                }
            } else {
                store.set(oppositeCDOObject, (EStructuralFeature)oppositeReference, 0, cdoObject);
            }
        }
    }

    private void adjustTransientOppositeReference(InternalEObject instance, InternalEObject object, EReference oppositeReference) {
        boolean wasDeliver = object.eDeliver();
        if (wasDeliver) {
            object.eSetDeliver(false);
        }
        try {
            if (oppositeReference.isMany()) {
                InternalEList list = (InternalEList)object.eGet((EStructuralFeature)oppositeReference);
                list.basicAdd((Object)instance, null);
            } else if (object.eGet((EStructuralFeature)oppositeReference) != instance) {
                object.eInverseAdd(instance, oppositeReference.getFeatureID(), instance.getClass(), null);
            }
        }
        finally {
            if (wasDeliver) {
                object.eSetDeliver(true);
            }
        }
    }

    private static final class Counter {
        private int value;

        public void increment() {
            ++this.value;
        }

        public int decrement() {
            return --this.value;
        }
    }

    private static interface LegacyProxy
    extends CDOIdentifiable {
    }

    private static final class LegacyProxyInvocationHandler
    implements InvocationHandler,
    LegacyProxy {
        private static final Method getIDMethod = ReflectUtil.getMethod(LegacyProxy.class, (String)"getID", (Class[])new Class[0]);
        private static final Method eIsProxyMethod = ReflectUtil.getMethod(EObject.class, (String)"eIsProxy", (Class[])new Class[0]);
        private static final Method eProxyURIMethod = ReflectUtil.getMethod(InternalEObject.class, (String)"eProxyURI", (Class[])new Class[0]);
        private CDOLegacyWrapper wrapper;
        private CDOID id;

        public LegacyProxyInvocationHandler(CDOLegacyWrapper wrapper, CDOID id) {
            this.wrapper = wrapper;
            this.id = id;
        }

        public CDOID getID() {
            return this.id;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.equals(getIDMethod)) {
                return this.id;
            }
            if (method.equals(eIsProxyMethod)) {
                return true;
            }
            if (method.equals(eProxyURIMethod)) {
                Resource resource = this.wrapper.eResource();
                return resource.getURI().appendFragment(this.id.toURIFragment());
            }
            throw new UnsupportedOperationException(method.getName());
        }
    }
}

