/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core.sourcelookup;

import java.io.File;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.sourcelookup.SourceLookupMessages;
import org.eclipse.cdt.debug.internal.core.sourcelookup.SourceUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.AbstractSourceContainer;

public class AbsolutePathSourceContainer
extends AbstractSourceContainer {
    public static final String TYPE_ID = String.valueOf(CDebugCorePlugin.getUniqueIdentifier()) + ".containerType.absolutePath";

    public boolean isValidAbsoluteFilePath(String name) {
        return this.isValidAbsoluteFilePath(new File(name));
    }

    public boolean isValidAbsoluteFilePath(File file) {
        return file.isAbsolute() && file.exists() && file.isFile();
    }

    public Object[] findSourceElements(String name) throws CoreException {
        File file;
        if (name != null && this.isValidAbsoluteFilePath(file = new File(name))) {
            return SourceUtils.findSourceElements(file, this.getDirector());
        }
        return new Object[0];
    }

    public String getName() {
        return SourceLookupMessages.AbsolutePathSourceContainer_0;
    }

    public ISourceContainerType getType() {
        return this.getSourceContainerType(TYPE_ID);
    }

    public int hashCode() {
        return TYPE_ID.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof AbsolutePathSourceContainer;
    }
}

