/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.wsdl11.xsd;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Set;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;

public class InlineXSDResolver
implements XMLEntityResolver {
    public static final String INLINE_SCHEMA_ID = "#inlineschema";
    protected final String FILE_PREFIX = "file:";
    protected final String XMLNS = "xmlns";
    protected Hashtable entities = new Hashtable();
    protected XMLEntityResolver externalResolver = null;
    protected XMLInputSource referringSchemaInputSource = null;
    protected String referringSchemaNamespace = null;

    public XMLInputSource resolveEntity(XMLResourceIdentifier resourceIdentifier) throws XNIException, IOException {
        String systemId = resourceIdentifier.getExpandedSystemId();
        String publicId = resourceIdentifier.getPublicId();
        String namespace = resourceIdentifier.getNamespace();
        XMLInputSource is = null;
        String schema = null;
        if (systemId == null) {
            if (publicId == null) {
                if (namespace == null) {
                    return null;
                }
                systemId = namespace;
            } else {
                systemId = publicId;
            }
        }
        if (this.referringSchemaNamespace != null && this.referringSchemaNamespace.equals(systemId)) {
            if (this.referringSchemaInputSource != null) {
                return this.referringSchemaInputSource;
            }
        } else {
            schema = (String)this.entities.get(systemId);
            if (schema != null && !schema.equals("")) {
                is = new XMLInputSource(publicId, String.valueOf(this.referringSchemaInputSource.getSystemId()) + INLINE_SCHEMA_ID, null, (Reader)new StringReader(schema), null);
            }
        }
        return is;
    }

    public void add(String targetNamespace, String schema) {
        this.entities.put(targetNamespace, schema);
    }

    public void addReferringSchema(XMLInputSource inputSource, String namespace) {
        this.referringSchemaInputSource = inputSource;
        this.referringSchemaNamespace = namespace;
    }

    public boolean isInlineSchema(String namespace) {
        return this.entities.containsKey(namespace);
    }

    public Set getInlineSchemaNSs() {
        return this.entities.keySet();
    }
}

