/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.ui.internal.properties.section;

import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.dtd.ui.internal.DTDUIPlugin;
import org.eclipse.wst.xml.core.internal.document.DocumentImpl;
import org.w3c.dom.Element;

public class AbstractSection
implements ISection,
IPropertyChangeListener,
Listener,
SelectionListener {
    private TabbedPropertySheetWidgetFactory factory;
    protected IWorkbenchPart fWorkbenchPart;
    protected ISelection fSelection;
    protected Object fInput;
    protected int rightMarginSpace;
    boolean listenerEnabled = true;
    protected DelayedEvent delayedTask;
    boolean isInDoHandle;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        this.createControls(parent, tabbedPropertySheetPage.getWidgetFactory());
    }

    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory aFactory) {
        this.factory = aFactory;
        GC gc = new GC((Drawable)parent);
        Point extent = gc.textExtent("  ...  ");
        this.rightMarginSpace = extent.x;
        gc.dispose();
    }

    public void setInput(IWorkbenchPart part, ISelection sel) {
        Assert.isTrue((boolean)(sel instanceof IStructuredSelection), (String)("selection " + sel.getClass() + "is not structured"));
        this.fWorkbenchPart = part;
        this.fSelection = sel;
        this.fInput = ((IStructuredSelection)this.fSelection).getFirstElement();
    }

    public void aboutToBeShown() {
        this.refresh();
    }

    public void aboutToBeHidden() {
    }

    public void dispose() {
    }

    public int getMinimumHeight() {
        return -1;
    }

    public boolean shouldUseExtraSpace() {
        return false;
    }

    public void refresh() {
    }

    public Object getInput() {
        boolean cfr_ignored_0 = this.fInput instanceof Element;
        return this.fInput;
    }

    public TabbedPropertySheetWidgetFactory getWidgetFactory() {
        return this.factory;
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.refresh();
    }

    public void doWidgetDefaultSelected(SelectionEvent e) {
    }

    public void doWidgetSelected(SelectionEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (this.isListenerEnabled() && this.getInput() != null && !this.isInDoHandle) {
            this.isInDoHandle = true;
            this.doWidgetDefaultSelected(e);
            this.isInDoHandle = false;
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.isListenerEnabled() && this.getInput() != null && !this.isInDoHandle) {
            this.isInDoHandle = true;
            this.doWidgetSelected(e);
            this.isInDoHandle = false;
        }
    }

    public boolean isListenerEnabled() {
        return this.listenerEnabled;
    }

    public void setListenerEnabled(boolean v) {
        this.listenerEnabled = v;
    }

    public void handleEvent(Event event) {
        if (this.isListenerEnabled() && !this.isInDoHandle) {
            this.isInDoHandle = true;
            this.startDelayedEvent(event);
            this.isInDoHandle = false;
        }
    }

    public void doHandleEvent(Event event) {
    }

    protected void startDelayedEvent(Event e) {
        if (this.delayedTask == null || this.delayedTask.getEvent() == null) {
            this.delayedTask = new DelayedEvent();
            this.delayedTask.setEvent(e);
            Display.getDefault().timerExec(500, (Runnable)this.delayedTask);
        } else {
            Event delayedEvent = this.delayedTask.getEvent();
            if (e.widget == delayedEvent.widget && e.type == delayedEvent.type) {
                this.delayedTask.setEvent(null);
            }
            this.delayedTask = new DelayedEvent();
            this.delayedTask.setEvent(e);
            Display.getDefault().timerExec(500, (Runnable)this.delayedTask);
        }
    }

    public boolean isInDoHandle() {
        return this.isInDoHandle;
    }

    protected static IEditorPart getActiveEditor() {
        IWorkbench workbench = DTDUIPlugin.getDefault().getWorkbench();
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        IEditorPart editorPart = workbenchWindow.getActivePage().getActiveEditor();
        return editorPart;
    }

    protected static IStatusLineManager getStatusLineManager(IEditorPart editorPart) {
        IStatusLineManager result = null;
        try {
            EditorActionBarContributor contributor = (EditorActionBarContributor)editorPart.getEditorSite().getActionBarContributor();
            result = contributor.getActionBars().getStatusLineManager();
        }
        catch (Exception exception) {}
        return result;
    }

    DocumentImpl getDocument(Element element) {
        return (DocumentImpl)element.getOwnerDocument();
    }

    public void beginRecording(String description, Element element) {
        DocumentImpl doc = this.getDocument(element);
        doc.getModel().beginRecording((Object)this, description);
    }

    public void endRecording(Element element) {
        DocumentImpl doc = this.getDocument(element);
        doc.getModel().endRecording((Object)this);
    }

    protected boolean validateName(String name) {
        return true;
    }

    protected boolean validateLanguage(String lang) {
        return true;
    }

    protected boolean validatePrefix(String prefix) {
        return true;
    }

    class DelayedEvent
    implements Runnable {
        protected Event event;

        DelayedEvent() {
        }

        @Override
        public void run() {
            if (this.event != null) {
                AbstractSection.this.isInDoHandle = true;
                AbstractSection.this.doHandleEvent(this.event);
                AbstractSection.this.isInDoHandle = false;
                this.event = null;
            }
        }

        public Event getEvent() {
            return this.event;
        }

        public void setEvent(Event e) {
            this.event = e;
        }
    }
}

