/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.model.property.accessor;

import java.lang.reflect.Method;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.accessor.AccessorUtils;
import org.eclipse.wb.internal.core.model.property.table.PropertyTooltipProvider;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.property.accessor.ExpressionAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MethodExpressionAccessor
extends ExpressionAccessor {
    private final Method m_setter;
    private final Method m_getter;
    private final PropertyTooltipProvider m_tooltipProvider;

    public MethodExpressionAccessor(String attribute, Method setter, Method getter) {
        super(attribute);
        this.m_setter = setter;
        this.m_getter = getter;
        this.m_tooltipProvider = AccessorUtils.PropertyTooltipProvider_forMethod((Method)setter);
    }

    @Override
    public Object getDefaultValue(XmlObjectInfo object) throws Exception {
        return object.getArbitraryValue(this);
    }

    @Override
    public void visit(XmlObjectInfo object, int state) throws Exception {
        super.visit(object, state);
        if (state == 1) {
            object.putArbitraryValue(this, this.askDefaultValue(object));
        }
    }

    private Object askDefaultValue(final XmlObjectInfo object) {
        if (this.m_getter != null) {
            return ExecutionUtils.runObjectIgnore((RunnableObjectEx)new RunnableObjectEx<Object>(){

                public Object runObject() throws Exception {
                    Object toolkitObject = object.getObject();
                    return MethodExpressionAccessor.this.m_getter.invoke(toolkitObject, new Object[0]);
                }
            }, (Object)Property.UNKNOWN_VALUE);
        }
        return Property.UNKNOWN_VALUE;
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == PropertyTooltipProvider.class) {
            return adapter.cast(this.m_tooltipProvider);
        }
        return super.getAdapter(adapter);
    }

    public Method getSetter() {
        return this.m_setter;
    }

    public Method getGetter() {
        return this.m_getter;
    }
}

