/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.viewers.runtime.specifications;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collections;
import org.eclipse.viatra.addon.viewers.runtime.notation.HierarchyPolicy;
import org.eclipse.viatra.addon.viewers.runtime.specifications.SpecificationDescriptorUtilities;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.matchers.planning.QueryProcessingException;
import org.eclipse.viatra.query.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.viatra.query.runtime.matchers.psystem.annotations.ParameterReference;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.transformation.views.traceability.generic.AbstractQuerySpecificationDescriptor;

public class ItemQuerySpecificationDescriptor
extends AbstractQuerySpecificationDescriptor {
    public static final String ANNOTATION_ID = "Item";
    private static final String SOURCE_PARAMETER_NAME = "item";
    private static final String LABEL_PARAMETER_NAME = "label";
    private static final String HIERARCHY_PARAMETER_NAME = "hierarchy";
    private final String source;
    private final String label;
    private final HierarchyPolicy policy;
    private final PAnnotation formatAnnotation;

    public ItemQuerySpecificationDescriptor(IQuerySpecification<?> specification, PAnnotation annotation) {
        super(specification, ItemQuerySpecificationDescriptor.getTraceSource(specification, annotation), (Multimap)ArrayListMultimap.create(), Collections.emptyMap());
        String parameterNameValue;
        ParameterReference parameterName = (ParameterReference)annotation.getFirstValue(SOURCE_PARAMETER_NAME, ParameterReference.class).orElseThrow(() -> new QueryProcessingException("Invalid item value", (Object)specification));
        this.source = parameterNameValue = parameterName.getName();
        this.label = annotation.getFirstValue(LABEL_PARAMETER_NAME, String.class).orElse("");
        this.policy = annotation.getFirstValue(HIERARCHY_PARAMETER_NAME, String.class).map(input -> HierarchyPolicy.valueOf(input.toUpperCase())).orElse(HierarchyPolicy.ALWAYS);
        this.formatAnnotation = specification.getFirstAnnotationByName("Format").orElse(null);
    }

    private static Multimap<PParameter, PParameter> getTraceSource(IQuerySpecification<?> specification, PAnnotation annotation) {
        ArrayListMultimap traces = ArrayListMultimap.create();
        ParameterReference parameterSource = (ParameterReference)annotation.getFirstValue(SOURCE_PARAMETER_NAME, ParameterReference.class).orElseThrow(() -> new QueryProcessingException("Invalid source value", (Object)specification));
        SpecificationDescriptorUtilities.insertToTraces(specification, (Multimap<PParameter, PParameter>)traces, parameterSource.getName());
        return traces;
    }

    public boolean isFormatted() {
        return this.formatAnnotation != null;
    }

    public PAnnotation getFormatAnnotation() {
        return this.formatAnnotation;
    }

    public String getSource() {
        return this.source;
    }

    public String getLabel() {
        return this.label;
    }

    public HierarchyPolicy getPolicy() {
        return this.policy;
    }
}

