/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.resources;

import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.analysis.os.linux.core.signals.TmfCpuSelectedSignal;
import org.eclipse.tracecompass.analysis.os.linux.core.signals.TmfThreadSelectedSignal;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.resourcesstatus.ResourcesEntryModel;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.Messages;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.actions.FollowCpuAction;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.actions.FollowThreadAction;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.actions.UnfollowCpuAction;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.actions.UnfollowThreadAction;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.resources.ResourcesPresentationProvider;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.BaseDataProviderTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NamedTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class ResourcesView
extends BaseDataProviderTimeGraphView {
    public static final @NonNull String ID = "org.eclipse.tracecompass.analysis.os.linux.views.resources";
    public static final @NonNull String RESOURCES_FOLLOW_CPU = "org.eclipse.tracecompass.analysis.os.linux.views.resources.FOLLOW_CPU";
    @Deprecated
    public static final @NonNull String RESOURCES_FOLLOW_CURRENT_THREAD = "org.eclipse.tracecompass.analysis.os.linux.views.resources.FOLLOW_CURRENT_THREAD";
    private static final String EMPTY_STRING = "";
    private String fFollowedThread = "";
    private static final String[] FILTER_COLUMN_NAMES = new String[]{Messages.ResourcesView_stateTypeName};
    private static final @NonNull List<// Could not load outer class - annotation placement on inner may be incorrect
    ResourcesEntryModel.Type> CPU_GROUP_ORDER = Arrays.asList(ResourcesEntryModel.Type.CURRENT_THREAD, ResourcesEntryModel.Type.CPU, ResourcesEntryModel.Type.FREQUENCY, ResourcesEntryModel.Type.GROUP);
    private static final Comparator<ResourcesEntryModel> COMPARATOR = Comparator.comparing(entry -> CPU_GROUP_ORDER.contains(entry.getType()) ? ResourcesEntryModel.Type.GROUP : entry.getType()).thenComparing(ResourcesEntryModel::getResourceId).thenComparing(entry -> CPU_GROUP_ORDER.indexOf(entry.getType()));

    public ResourcesView() {
        super(ID, (TimeGraphPresentationProvider)new ResourcesPresentationProvider(), "org.eclipse.tracecompass.internal.analysis.os.linux.core.threadstatus.ResourcesStatusDataProvider");
        this.setFilterColumns(FILTER_COLUMN_NAMES);
        this.setFilterLabelProvider(new ResourcesFilterLabelProvider());
        this.setEntryComparator(new ResourcesEntryComparator());
        this.setAutoExpandLevel(1);
    }

    protected void fillTimeGraphEntryContextMenu(@NonNull IMenuManager menuManager) {
        ResourcesEntryModel resourcesModel;
        ResourcesEntryModel.Type type;
        TimeGraphEntry resourcesEntry;
        ITmfTreeDataModel model;
        IStructuredSelection sSel;
        ISelection selection = this.getSite().getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection && (sSel = (IStructuredSelection)selection).getFirstElement() instanceof TimeGraphEntry && (model = (resourcesEntry = (TimeGraphEntry)sSel.getFirstElement()).getEntryModel()) instanceof ResourcesEntryModel && ((type = (resourcesModel = (ResourcesEntryModel)model).getType()) == ResourcesEntryModel.Type.CPU || type == ResourcesEntryModel.Type.CURRENT_THREAD)) {
            int cpu;
            ITmfTrace trace = ResourcesView.getTrace((TimeGraphEntry)resourcesEntry);
            TmfTraceContext ctx = TmfTraceManager.getInstance().getTraceContext(trace);
            Integer data = (Integer)ctx.getData(RESOURCES_FOLLOW_CPU);
            int n = cpu = data != null ? data : -1;
            if (cpu >= 0) {
                menuManager.add((IAction)new UnfollowCpuAction((TmfView)this, resourcesModel.getResourceId(), trace));
            } else {
                menuManager.add((IAction)new FollowCpuAction((TmfView)this, resourcesModel.getResourceId(), trace));
            }
        }
    }

    protected void fillTimeEventContextMenu(@NonNull IMenuManager menuManager) {
        IStructuredSelection sSel;
        ISelection selection = this.getSite().getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection && (sSel = (IStructuredSelection)selection).getFirstElement() instanceof TimeGraphEntry) {
            TimeGraphEntry resourcesEntry = (TimeGraphEntry)sSel.getFirstElement();
            ITmfTreeDataModel model = resourcesEntry.getEntryModel();
            if (sSel.toArray()[1] instanceof NamedTimeEvent && ((ResourcesEntryModel)model).getType() == ResourcesEntryModel.Type.CURRENT_THREAD) {
                ITmfTrace trace = ResourcesView.getTrace((TimeGraphEntry)resourcesEntry);
                NamedTimeEvent event = (NamedTimeEvent)sSel.toArray()[1];
                TmfTraceContext ctx = TmfTraceManager.getInstance().getCurrentTraceContext();
                HostThread data = (HostThread)ctx.getData("model.selectedThread");
                if (data != null) {
                    menuManager.add((IAction)new UnfollowThreadAction((TmfView)this));
                } else {
                    menuManager.add((IAction)new FollowThreadAction((TmfView)this, null, event.getValue(), trace));
                }
            }
        }
        super.fillTimeEventContextMenu(menuManager);
    }

    protected String getNextText() {
        return Messages.ResourcesView_nextResourceActionNameText;
    }

    protected String getNextTooltip() {
        return Messages.ResourcesView_nextResourceActionToolTipText;
    }

    protected String getPrevText() {
        return Messages.ResourcesView_previousResourceActionNameText;
    }

    protected String getPrevTooltip() {
        return Messages.ResourcesView_previousResourceActionToolTipText;
    }

    private void setFollowedThread(String regex) {
        this.fFollowedThread = regex;
    }

    private void removeFollowedThread() {
        this.fFollowedThread = EMPTY_STRING;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull Multimap<@NonNull Integer, @NonNull String> getRegexes() {
        @NonNull @NonNull Multimap regexes = super.getRegexes();
        if (!this.fFollowedThread.isEmpty()) {
            regexes.put((Object)2, (Object)this.fFollowedThread);
        } else {
            regexes.removeAll((Object)2);
        }
        return regexes;
    }

    @TmfSignalHandler
    public void listenToCpu(TmfCpuSelectedSignal signal) {
        int data = signal.getCore() >= 0 ? signal.getCore() : -1;
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return;
        }
        TmfTraceManager.getInstance().updateTraceContext(trace, builder -> builder.setData(RESOURCES_FOLLOW_CPU, (Object)data));
    }

    @TmfSignalHandler
    public void listenToCurrentThread(TmfThreadSelectedSignal signal) {
        HostThread data = signal.getThreadId() >= 0 ? signal.getHostThread() : null;
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return;
        }
        TmfTraceManager.getInstance().updateTraceContext(trace, builder -> builder.setData("model.selectedThread", (Object)data));
        if (data != null) {
            this.setFollowedThread("Current_thread==" + data.getTid() + " || TID==" + data.getTid());
        } else {
            this.removeFollowedThread();
        }
        this.restartZoomThread();
    }

    private static class ResourcesEntryComparator
    implements Comparator<ITimeGraphEntry> {
        private ResourcesEntryComparator() {
        }

        @Override
        public int compare(ITimeGraphEntry o1, ITimeGraphEntry o2) {
            if (o1 instanceof BaseDataProviderTimeGraphView.TraceEntry && o2 instanceof BaseDataProviderTimeGraphView.TraceEntry) {
                return o1.getName().compareTo(o2.getName());
            }
            if (o1 instanceof TimeGraphEntry && o2 instanceof TimeGraphEntry) {
                ITmfTreeDataModel model1 = ((TimeGraphEntry)o1).getEntryModel();
                ITmfTreeDataModel model2 = ((TimeGraphEntry)o2).getEntryModel();
                if (model1 instanceof ResourcesEntryModel && model2 instanceof ResourcesEntryModel) {
                    return COMPARATOR.compare((ResourcesEntryModel)model1, (ResourcesEntryModel)model2);
                }
            }
            return 0;
        }
    }

    private static class ResourcesFilterLabelProvider
    extends AbstractTimeGraphView.TreeLabelProvider {
        private ResourcesFilterLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0 && element instanceof TimeGraphEntry) {
                return ((TimeGraphEntry)element).getName();
            }
            return ResourcesView.EMPTY_STRING;
        }
    }
}

