/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.api.query;

import com.google.common.base.Preconditions;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ExtendedMetaData;

public class NotificationQuery {
    private final Notification notification;

    public NotificationQuery(Notification notification) {
        this.notification = (Notification)Preconditions.checkNotNull((Object)notification);
    }

    public boolean isTransientNotification() {
        if (this.isNotificationOnTransientFeature()) {
            return true;
        }
        return this.isNotificationOnEObjectContainedThroughTransientFeature();
    }

    private boolean isNotificationOnTransientFeature() {
        return this.notification.getFeature() instanceof EStructuralFeature && ((EStructuralFeature)this.notification.getFeature()).isTransient();
    }

    private boolean isNotificationOnEObjectContainedThroughTransientFeature() {
        if (this.notification.getNotifier() instanceof EObject) {
            EObject obj = (EObject)this.notification.getNotifier();
            return this.isContainedThroughTransientFeature(obj);
        }
        return false;
    }

    private boolean isContainedThroughTransientFeature(EObject obj) {
        EObject current = obj;
        while (current.eContainer() != null) {
            EObject container = current.eContainer();
            if (current.eContainingFeature().isTransient() && !ExtendedMetaData.INSTANCE.isDocumentRoot(container.eClass())) {
                return true;
            }
            current = container;
        }
        return false;
    }
}

