/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.template;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.scout.sdk.core.s.ScoutModelHierarchy;
import org.eclipse.scout.sdk.core.util.JavaTypes;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;
import org.eclipse.scout.sdk.s2e.ui.internal.template.AbstractTypeProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.TypeProposalContext;

public class TemplateProposalDescriptor {
    private static final Pattern CAMEL_PAT = Pattern.compile("([A-Z])");
    private final String m_proposalIfcTypeFqn;
    private final Deque<String> m_defaultSuperTypeFqns;
    private final Set<String> m_aliasNames;
    private final Class<? extends AbstractTypeProposal> m_proposalClass;
    private String m_defaultNameOfNewType;
    private String m_typeSuffix;
    private String m_imgId;
    private int m_relevance;
    private String m_displayName;

    protected TemplateProposalDescriptor(String proposalIfcTypeFqn, String defaultSuperTypeFqn, String defaultNameOfNewType, String typeSuffix, String imgId, int relevance, Class<? extends AbstractTypeProposal> proposal) {
        this(proposalIfcTypeFqn, defaultSuperTypeFqn, defaultNameOfNewType, typeSuffix, imgId, relevance, proposal, null);
    }

    protected TemplateProposalDescriptor(String proposalIfcTypeFqn, String defaultSuperTypeFqn, String defaultNameOfNewType, String typeSuffix, String imgId, int relevance, Class<? extends AbstractTypeProposal> proposal, Collection<String> alias) {
        this(proposalIfcTypeFqn, defaultSuperTypeFqn, defaultNameOfNewType, typeSuffix, imgId, relevance, proposal, alias, TemplateProposalDescriptor.createDisplayNameFromIfc(proposalIfcTypeFqn));
    }

    protected TemplateProposalDescriptor(String proposalIfcTypeFqn, String defaultSuperTypeFqn, String defaultNameOfNewType, String typeSuffix, String imgId, int relevance, Class<? extends AbstractTypeProposal> proposal, Collection<String> alias, String displayName) {
        this.m_proposalIfcTypeFqn = proposalIfcTypeFqn;
        this.m_defaultSuperTypeFqns = new ArrayDeque<String>();
        this.m_defaultSuperTypeFqns.add(defaultSuperTypeFqn);
        this.m_aliasNames = alias == null || alias.isEmpty() ? new HashSet<String>(0) : new HashSet<String>(alias);
        this.m_defaultNameOfNewType = defaultNameOfNewType;
        this.m_typeSuffix = typeSuffix;
        this.m_imgId = imgId;
        this.m_relevance = relevance;
        this.m_displayName = displayName;
        this.m_proposalClass = proposal;
    }

    public boolean isActiveFor(Collection<String> possibleChildren, IJavaProject context, String searchString) {
        if (context == null) {
            return false;
        }
        if (possibleChildren == null || possibleChildren.isEmpty()) {
            return false;
        }
        for (String possibleChild : possibleChildren) {
            if (!ScoutModelHierarchy.isSubtypeOf((String)this.m_proposalIfcTypeFqn, (String)possibleChild) || !this.acceptSearchString(searchString)) continue;
            return true;
        }
        return false;
    }

    protected boolean acceptSearchString(String searchString) {
        if (Strings.isBlank((CharSequence)searchString)) {
            return true;
        }
        searchString = searchString.toLowerCase(Locale.ENGLISH);
        if (JavaTypes.simpleName((CharSequence)this.m_proposalIfcTypeFqn).toLowerCase(Locale.ENGLISH).contains(searchString)) {
            return true;
        }
        if (this.m_displayName.toLowerCase(Locale.ENGLISH).contains(searchString)) {
            return true;
        }
        for (String defaultSuperType : this.m_defaultSuperTypeFqns) {
            String simpleName = JavaTypes.simpleName((CharSequence)defaultSuperType);
            if (simpleName.startsWith("Abstract")) {
                simpleName = simpleName.substring("Abstract".length());
            }
            if (!simpleName.toLowerCase(Locale.ENGLISH).contains(searchString)) continue;
            return true;
        }
        for (String alias : this.m_aliasNames) {
            if (!alias.toLowerCase(Locale.ENGLISH).contains(searchString)) continue;
            return true;
        }
        return false;
    }

    public ICompletionProposal createProposal(ICompilationUnit icu, int pos, ISourceRange surroundingTypeNameRange, Future<EclipseEnvironment> provider, String searchString) {
        try {
            TypeProposalContext context = new TypeProposalContext();
            context.setProvider(provider);
            context.setDefaultName(this.getDefaultNameOfNewType());
            context.setDefaultSuperClasses(this.getDefaultSuperTypeFqns());
            context.setPosition(pos);
            context.setSuffix(this.getTypeSuffix());
            context.setProposalInterfaceFqn(this.getProposalInterfaceFqn());
            context.setIcu(icu);
            context.setSurroundingTypeNameRange(surroundingTypeNameRange);
            context.setSearchString(searchString);
            return (ICompletionProposal)this.m_proposalClass.getConstructors()[0].newInstance(this.getDisplayName(), this.getRelevance(), this.getImageId(), icu, context);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            throw new SdkException("Unable to create proposal '" + this.m_proposalClass.getName() + "'.", new Object[]{e});
        }
    }

    protected static String createDisplayNameFromIfc(CharSequence ifcFqn) {
        String simpleName = JavaTypes.simpleName((CharSequence)ifcFqn);
        if (!simpleName.isEmpty() && simpleName.charAt(0) == 'I') {
            simpleName = simpleName.substring(1);
        }
        return CAMEL_PAT.matcher(simpleName).replaceAll(" $1");
    }

    public Deque<String> getDefaultSuperTypeFqns() {
        return this.m_defaultSuperTypeFqns;
    }

    public String getDefaultNameOfNewType() {
        return this.m_defaultNameOfNewType;
    }

    public void setDefaultNameOfNewType(String defaultNameOfNewType) {
        this.m_defaultNameOfNewType = defaultNameOfNewType;
    }

    public String getTypeSuffix() {
        return this.m_typeSuffix;
    }

    public void setTypeSuffix(String typeSuffix) {
        this.m_typeSuffix = typeSuffix;
    }

    public String getImageId() {
        return this.m_imgId;
    }

    public void setImageId(String imgId) {
        this.m_imgId = imgId;
    }

    public int getRelevance() {
        return this.m_relevance;
    }

    public void setRelevance(int relevance) {
        this.m_relevance = relevance;
    }

    public String getDisplayName() {
        return this.m_displayName;
    }

    public void setDisplayName(String displayName) {
        this.m_displayName = displayName;
    }

    public Class<? extends AbstractTypeProposal> getProposal() {
        return this.m_proposalClass;
    }

    public String getProposalInterfaceFqn() {
        return this.m_proposalIfcTypeFqn;
    }

    public Set<String> getAliasNames() {
        return this.m_aliasNames;
    }
}

