/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.workbench.impl.part;

import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.swt.api.CTabItem;
import org.eclipse.reddeer.swt.api.Menu;
import org.eclipse.reddeer.swt.impl.ctab.DefaultCTabItem;
import org.eclipse.reddeer.swt.impl.menu.DefaultMenu;
import org.eclipse.reddeer.workbench.api.WorkbenchPart;
import org.eclipse.reddeer.workbench.handler.WorkbenchPartHandler;
import org.eclipse.reddeer.workbench.impl.shell.WorkbenchShell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractWorkbenchPart
implements WorkbenchPart {
    protected static final Logger log = Logger.getLogger(AbstractWorkbenchPart.class);
    protected CTabItem cTabItem;
    protected MPart mPart;

    public AbstractWorkbenchPart(MPart mPart) {
        this.mPart = mPart;
        this.cTabItem = new DefaultCTabItem((ReferencedComposite)new WorkbenchShell(), mPart.getLabel());
    }

    @Override
    public String getTitle() {
        return this.cTabItem.getText();
    }

    @Override
    public Image getTitleImage() {
        return this.cTabItem.getImage();
    }

    @Override
    public String getTitleToolTip() {
        return this.cTabItem.getToolTipText();
    }

    public Control getControl() {
        return this.cTabItem.getControl();
    }

    @Override
    public boolean isActive() {
        return this.cTabItem.isActive();
    }

    @Override
    public void activate() {
        this.cTabItem.activate();
    }

    @Override
    public void close() {
        this.cTabItem.close();
    }

    @Override
    public boolean isDirty() {
        return this.mPart.isDirty();
    }

    @Override
    public void save() {
        WorkbenchPartHandler.getInstance().save(this.mPart);
    }

    @Override
    public void close(boolean save) {
        WorkbenchPartHandler.getInstance().save(this.mPart);
        this.close();
    }

    @Override
    public Menu getContextMenu() {
        for (MMenu menu : this.mPart.getMenus()) {
            if (!menu.getElementId().startsWith("popup:") || !(menu.getWidget() instanceof org.eclipse.swt.widgets.Menu)) continue;
            return new DefaultMenu((org.eclipse.swt.widgets.Menu)menu.getWidget());
        }
        return null;
    }
}

