/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.core.handler;

import java.util.Arrays;
import java.util.List;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.core.handler.WidgetHandler;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class MenuHandler
extends WidgetHandler {
    private static MenuHandler instance;

    private MenuHandler() {
    }

    public static MenuHandler getInstance() {
        if (instance == null) {
            instance = new MenuHandler();
        }
        return instance;
    }

    public List<MenuItem> getItems(final Menu swtMenu) {
        MenuItem[] items = (MenuItem[])Display.syncExec((ResultRunnable)new ResultRunnable<MenuItem[]>(){

            public MenuItem[] run() {
                MenuHandler.this.sendHide(swtMenu, true);
                MenuHandler.this.sendShowUI((Widget)swtMenu);
                return swtMenu.getItems();
            }
        });
        return Arrays.asList(items);
    }

    public boolean isVisible(final Menu swtMenu) {
        return (Boolean)Display.syncExec((ResultRunnable)new ResultRunnable<Boolean>(){

            public Boolean run() {
                return swtMenu.isVisible();
            }
        });
    }

    public boolean isEnabled(final Menu swtMenu) {
        return (Boolean)Display.syncExec((ResultRunnable)new ResultRunnable<Boolean>(){

            public Boolean run() {
                return swtMenu.isEnabled();
            }
        });
    }

    public Menu getParentMenu(final Menu swtMenu) {
        return (Menu)Display.syncExec((ResultRunnable)new ResultRunnable<Menu>(){

            public Menu run() {
                return swtMenu.getParentMenu();
            }
        });
    }

    public void sendShowUI(Widget widget) {
        widget.notifyListeners(22, new Event());
    }

    public void sendHide(final Menu menu, final boolean recur) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (menu != null) {
                    menu.notifyListeners(23, new Event());
                    if (recur) {
                        if (menu.getParentMenu() != null) {
                            MenuHandler.this.sendHide(menu.getParentMenu(), recur);
                        } else {
                            menu.setVisible(false);
                        }
                    }
                }
            }
        });
    }
}

