/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.ems.core.managers;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ptp.ems.core.IEnvManager;
import org.eclipse.ptp.ems.core.IEnvManagerConfig;
import org.eclipse.ptp.internal.ems.core.EMSCorePlugin;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteFileService;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.remote.core.IRemoteProcessBuilder;
import org.eclipse.remote.core.IRemoteProcessService;
import org.eclipse.remote.core.exception.RemoteConnectionException;

public abstract class AbstractEnvManager
implements IEnvManager {
    private static final long TIMEOUT = 10000L;
    protected static final Comparator<String> MODULE_NAME_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String s, String t) {
            if (!($assertionsDisabled || s != null && t != null)) {
                throw new AssertionError();
            }
            return s.compareToIgnoreCase(t);
        }
    };
    private IRemoteConnection remoteConnection = null;

    @Override
    public Comparator<String> getComparator() {
        return MODULE_NAME_COMPARATOR;
    }

    @Override
    public final void configure(IRemoteConnection remoteConnection) {
        if (remoteConnection == null) {
            throw new IllegalArgumentException("remoteConnection must be non-null");
        }
        this.remoteConnection = remoteConnection;
    }

    protected final IRemoteConnection getRemoteConnection() {
        if (this.remoteConnection == null) {
            throw new IllegalStateException("remoteConnection cannot be null");
        }
        return this.remoteConnection;
    }

    protected final List<String> runCommand(IProgressMonitor pm, boolean requireCleanExit, String ... command) throws RemoteConnectionException, IOException {
        this.log(1, "Running remote command; clean exit%s required:", requireCleanExit ? "" : " not");
        int i = 0;
        while (i < command.length) {
            this.log(1, "[%d] %s", i, command[i]);
            ++i;
        }
        IRemoteProcessBuilder processBuilder = this.createRemoteProcessBuilder(pm, command);
        if (processBuilder == null) {
            this.log(4, "- Could not create remote process builder", new Object[0]);
            return null;
        }
        IRemoteProcess p = processBuilder.start();
        if (p == null) {
            this.log(4, "- Could not start remote process builder", new Object[0]);
            return null;
        }
        long start = System.currentTimeMillis();
        while (!AbstractEnvManager.hasTerminated(p) && System.currentTimeMillis() - start < 10000L) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (AbstractEnvManager.hasTerminated(p)) {
            int severity = p.exitValue() == 0 ? 1 : 2;
            this.log(severity, "- Remote process terminated with exit code %d", p.exitValue());
        } else {
            this.log(2, "- Remote process timed out", new Object[0]);
        }
        ArrayList<String> result = new ArrayList<String>(256);
        this.readLines(p.getInputStream(), result);
        this.readLines(p.getErrorStream(), result);
        this.log(1, "- Lines read: %d", result.size());
        p.destroy();
        this.log(1, "- Remote process destroyed", new Object[0]);
        if (requireCleanExit && (!AbstractEnvManager.hasTerminated(p) || p.exitValue() != 0)) {
            return Collections.emptyList();
        }
        return result;
    }

    protected final void log(int severity, String format, Object ... args) {
        String message = String.format(format, args);
        if (EMSCorePlugin.getDefault().isDebugging()) {
            System.out.println(message);
        }
        if (severity == 4 || severity == 2) {
            EMSCorePlugin.log((IStatus)new Status(severity, "org.eclipse.ptp.ems.core", message));
        }
    }

    private static boolean hasTerminated(IRemoteProcess p) {
        return p.isCompleted();
    }

    private IRemoteProcessBuilder createRemoteProcessBuilder(IProgressMonitor pm, String ... command) throws RemoteConnectionException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pm, (int)100);
        IRemoteConnection connection = this.getRemoteConnection();
        if (connection != null) {
            IRemoteProcessService processService;
            if (!connection.isOpen()) {
                connection.open((IProgressMonitor)monitor.newChild(80));
            }
            if (connection.isOpen() && (processService = (IRemoteProcessService)connection.getService(IRemoteProcessService.class)) != null) {
                return processService.getProcessBuilder(command);
            }
        }
        return null;
    }

    private void readLines(InputStream input, List<String> result) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(input));
        String line = in.readLine();
        while (line != null) {
            result.add(line);
            line = in.readLine();
        }
        in.close();
    }

    protected final List<String> runCommandInBashLoginShell(IProgressMonitor pm, String command) throws RemoteConnectionException, IOException {
        return this.runCommand(pm, false, "bash", "--login", "-c", command);
    }

    @Override
    public String getBashConcatenation(String separator, boolean echo, IEnvManagerConfig config, String commandToExecuteAfterward) {
        StringBuilder sb = new StringBuilder();
        if (config.isEnvMgmtEnabled()) {
            if (config.isManualConfigEnabled()) {
                this.concatenateManualConfigText(separator, config.getManualConfigText(), sb);
            } else {
                this.concatenate(separator, this.getInitialBashCommands(echo), sb);
                for (String moduleName : config.getConfigElements()) {
                    this.concatenate(separator, this.getBashCommand(echo, moduleName), sb);
                }
            }
        }
        if (commandToExecuteAfterward != null) {
            if (echo) {
                this.concatenate(separator, "echo '" + commandToExecuteAfterward + "'", sb);
            }
            this.concatenate(separator, commandToExecuteAfterward, sb);
        }
        return sb.toString();
    }

    private void concatenateManualConfigText(String separator, String manualConfigText, StringBuilder sb) {
        if (separator.contains(";")) {
            String[] lines = manualConfigText.split("\n");
            boolean lastLineWasBashControlLine = false;
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (this.isBashComment(line) || this.isBlankLine(line)) {
                    lastLineWasBashControlLine = false;
                } else if (this.isBashControlLine(line)) {
                    this.concatenate(separator, line, sb);
                    lastLineWasBashControlLine = true;
                } else {
                    if (lastLineWasBashControlLine) {
                        this.concatenate("", line, sb);
                    } else {
                        this.concatenate(separator, line, sb);
                    }
                    lastLineWasBashControlLine = false;
                }
                ++n2;
            }
        } else {
            this.concatenate(separator, manualConfigText, sb);
        }
    }

    private boolean isBlankLine(String line) {
        return line.trim().equals("");
    }

    private boolean isBashComment(String line) {
        return line.trim().startsWith("#");
    }

    private boolean isBashControlLine(String line) {
        return (line = line.trim()).startsWith("for") && line.endsWith("do") || line.startsWith("select") && line.endsWith("do") || line.startsWith("if") && line.endsWith("then") || line.startsWith("elif") && line.endsWith("then") || line.equals("else") || line.startsWith("while") && line.endsWith("do") || line.startsWith("until") && line.endsWith("do");
    }

    private void concatenate(String separator, List<String> commands, StringBuilder sb) {
        for (String command : commands) {
            this.concatenate(separator, command, sb);
        }
    }

    private void concatenate(String separator, String command, StringBuilder sb) {
        if (sb.length() > 0) {
            sb.append(separator);
        }
        sb.append(command);
    }

    @Override
    public String createBashScript(IProgressMonitor pm, boolean echo, IEnvManagerConfig config, String commandToExecuteAfterward) throws RemoteConnectionException, IOException {
        String pathToTempFile = this.createTempFile(pm);
        this.checkTempFile(pathToTempFile);
        this.writeBashScript(echo, pathToTempFile, config, commandToExecuteAfterward);
        return pathToTempFile;
    }

    private String createTempFile(IProgressMonitor pm) throws RemoteConnectionException, IOException {
        List<String> output = this.runCommand(pm, true, "mktemp", "-qt", "ptpscript_XXXXXX");
        if (output.isEmpty()) {
            throw new IOException("No output from mktemp -t ptpscript");
        }
        return output.get(0);
    }

    private void checkTempFile(String pathToTempFile) throws IOException {
        IFileStore script;
        IFileInfo info;
        IRemoteFileService fileService = (IRemoteFileService)this.getRemoteConnection().getService(IRemoteFileService.class);
        if (fileService != null && ((info = (script = fileService.getResource(pathToTempFile)).fetchInfo()).isDirectory() || info.getLength() > 0L)) {
            throw new IOException("Temp file from mktemp -t ptpscript is invalid");
        }
    }

    private void writeBashScript(boolean echo, String pathToTempFile, IEnvManagerConfig config, String commandToExecuteAfterward) {
        IRemoteFileService fileService = (IRemoteFileService)this.getRemoteConnection().getService(IRemoteFileService.class);
        if (fileService != null) {
            IFileStore script = fileService.getResource(pathToTempFile);
            PrintStream out = null;
            try {
                out = new PrintStream(new BufferedOutputStream(script.openOutputStream(0, null)));
                out.print("#!/bin/bash --login\n");
                out.print("echo ''\n");
                out.print("echo '**** Environment configuration script temporarily stored in " + pathToTempFile + " ****'\n");
                if (config.isEnvMgmtEnabled()) {
                    if (config.isManualConfigEnabled()) {
                        out.print(String.valueOf(config.getManualConfigText().replace("\r\n", "\n")) + "\n");
                    } else {
                        for (String command : this.getInitialBashCommands(echo)) {
                            out.print(String.valueOf(command) + "\n");
                        }
                        for (String moduleName : config.getConfigElements()) {
                            for (String command : this.getBashCommand(echo, moduleName)) {
                                out.print(String.valueOf(command) + "\n");
                            }
                        }
                    }
                }
                if (commandToExecuteAfterward != null && commandToExecuteAfterward.length() > 0) {
                    if (echo) {
                        out.print("echo '" + commandToExecuteAfterward + "'\n");
                    }
                    out.print(String.valueOf(commandToExecuteAfterward) + "\n");
                }
                out.print("rm -f '" + pathToTempFile + "'\n");
                out.flush();
                out.close();
            }
            catch (Exception e) {
                EMSCorePlugin.log(e);
                if (out != null) {
                    out.close();
                }
                this.attemptToDelete(script);
            }
        }
    }

    private boolean attemptToDelete(IFileStore script) {
        try {
            script.delete(0, null);
            return true;
        }
        catch (CoreException e) {
            EMSCorePlugin.log(e);
            return false;
        }
    }

    protected abstract List<String> getInitialBashCommands(boolean var1);

    protected abstract List<String> getBashCommand(boolean var1, String var2);
}

