/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;

public class OutlineFilter {
    public static IModelElement[] filterChildrenForOutline(Object parent, IModelElement[] children) {
        return OutlineFilter.filterDuplicatePublicVars(parent, OutlineFilter.filter(children));
    }

    public static IModelElement[] filter(IModelElement[] children) {
        ArrayList<IModelElement> v = new ArrayList<IModelElement>();
        int i = 0;
        while (i < children.length) {
            if (!OutlineFilter.matches(children[i])) {
                v.add(children[i]);
            }
            ++i;
        }
        return v.toArray(new IModelElement[v.size()]);
    }

    public static IModelElement[] filterDuplicatePublicVars(Object parent, IModelElement[] children) {
        if (!(parent instanceof ISourceModule)) {
            return children;
        }
        TreeSet<IModelElement> result = new TreeSet<IModelElement>(new Comparator<IModelElement>(){

            @Override
            public int compare(IModelElement o1, IModelElement o2) {
                if (o1 instanceof IField && o2 instanceof IField && PHPModelUtils.isSameField((IField)o1, (IField)o2)) {
                    return 0;
                }
                return 1;
            }
        });
        int i = 0;
        while (i < children.length) {
            result.add(children[i]);
            ++i;
        }
        return result.toArray(new IModelElement[result.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean matches(IModelElement element) {
        if (element.getElementType() == 9) {
            String name = element.getElementName();
            if (name == null) return false;
            if (name.indexOf(60) < 0) return false;
            return true;
        }
        IModelElement parent = element.getParent();
        if (parent == null) {
            if (element.getElementType() != 11) return false;
            return true;
        }
        int parentType = parent.getElementType();
        if (element.getElementType() != 8) return false;
        if (parentType != 9 && parentType != 7) {
            return false;
        }
        if (parentType != 9) return false;
        IField field = (IField)element;
        try {
            IModelElement[] iModelElementArray = field.getChildren();
            int n = iModelElementArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                IModelElement modelElement = iModelElementArray[n2];
                if (modelElement.getElementType() == 9) return false;
                if (modelElement.getElementType() == 7) {
                    return false;
                }
                ++n2;
            }
        }
        catch (ModelException e) {
            PHPCorePlugin.log(e);
        }
        return true;
    }
}

