/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.SimplePropertyDescriptor;
import org.eclipse.php.core.ast.nodes.Statement;
import org.eclipse.php.core.compiler.PHPFlags;

public abstract class BodyDeclaration
extends Statement {
    private int modifier;

    public abstract SimplePropertyDescriptor getModifierProperty();

    public BodyDeclaration(int start, int end, AST ast, int modifier, boolean shouldComplete) {
        super(start, end, ast);
        this.setModifier(shouldComplete ? BodyDeclaration.completeModifier(modifier) : modifier);
    }

    public BodyDeclaration(int start, int end, AST ast, int modifier) {
        this(start, end, ast, modifier, false);
    }

    public BodyDeclaration(AST ast) {
        super(ast);
    }

    private static int completeModifier(int mod) {
        if (!PHPFlags.isPrivate((int)mod) && !PHPFlags.isProtected((int)mod)) {
            mod |= 0x40;
        }
        return mod;
    }

    public String getModifierString() {
        return PHPFlags.toString(this.modifier);
    }

    public int getModifier() {
        return this.modifier;
    }

    public void setModifier(int modifier) {
        if (PHPFlags.toString(modifier) == null) {
            throw new IllegalArgumentException("Invalid modifier");
        }
        this.preValueChange(this.getModifierProperty());
        this.modifier = modifier;
        this.postValueChange(this.getModifierProperty());
    }

    @Override
    int internalGetSetIntProperty(SimplePropertyDescriptor property, boolean get, int value) {
        if (property == this.getModifierProperty()) {
            if (get) {
                return this.getModifier();
            }
            this.setModifier(value);
            return 0;
        }
        return super.internalGetSetIntProperty(property, get, value);
    }
}

