/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.figure.node;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.diagram.ui.figures.ShapeCompartmentFigure;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.PapyrusWrappingLabel;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.SVGNodePlateFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.ScalableCompartmentFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.CompartmentFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.NodeNamedElementFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.RoundedCompartmentFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.StereotypePropertiesCompartment;

public class AutomaticCompartmentLayoutManager
extends AbstractLayout {
    protected static final int MINIMUM_COMPARTMENT_HEIGHT = 15;
    protected ArrayList<IFigure> visibleCompartments = new ArrayList();
    protected ArrayList<IFigure> visibleOthers = new ArrayList();
    protected ArrayList<IFigure> invisibles = new ArrayList();
    protected boolean forcedLabelBounds = false;
    protected boolean addExtraHeight = true;

    public void setAddExtraHeight(boolean addExtraHeight) {
        this.addExtraHeight = addExtraHeight;
    }

    protected Dimension calculatePreferredSize(IFigure container, int hint, int hint2) {
        NodeNamedElementFigure cf;
        WrappingLabel wl;
        this.collectInformation(container);
        int minimumWith = 0;
        int minimumHeight = 0;
        if (container instanceof CompartmentFigure && (wl = (cf = (CompartmentFigure)container).getNameLabel()) != null && container.getChildren().contains(wl) && wl.getPreferredSize().width > minimumWith) {
            minimumWith = wl.getPreferredSize().width;
        }
        if (container instanceof RoundedCompartmentFigure) {
            int prefStereoWidth;
            PapyrusWrappingLabel stereotypeLabel;
            int prefNameWidth;
            cf = (RoundedCompartmentFigure)container;
            wl = cf.getNameLabel();
            if (wl != null && container.getChildren().contains(wl) && (prefNameWidth = wl.getPreferredSize().width) > minimumWith) {
                minimumWith = prefNameWidth + 2;
            }
            if ((stereotypeLabel = cf.getStereotypesLabel()) != null && container.getChildren().contains(stereotypeLabel) && (prefStereoWidth = stereotypeLabel.getPreferredSize().width) > minimumWith) {
                minimumWith = prefStereoWidth + 2;
            }
        }
        if (!this.visibleCompartments.isEmpty()) {
            for (Object o : container.getChildren()) {
                IFigure child = (IFigure)o;
                minimumHeight += child.getPreferredSize().height;
                minimumWith = Math.max(minimumWith, child.getPreferredSize().width);
            }
        } else {
            for (IFigure child : this.visibleOthers) {
                minimumHeight += child.getPreferredSize().height;
            }
        }
        if (this.addExtraHeight) {
            minimumHeight += 7;
        }
        return new Dimension(minimumWith, minimumHeight);
    }

    public Dimension getMinimumSize(IFigure container, int wHint, int hHint) {
        return new Dimension(10, 10);
    }

    public void layout(IFigure container) {
        this.collectInformation(container);
        Rectangle bounds = container.getBounds();
        if (!this.visibleCompartments.isEmpty()) {
            if (this.forcedLabelBounds && this.hasShapeDisplayed(container)) {
                this.layoutForcedLabel(container);
            } else {
                this.layoutDefault(container);
            }
        } else {
            this.layoutOthers(bounds);
        }
        this.layoutInvisibles(bounds.x + 3, bounds.getBottomLeft().y + 1);
    }

    protected boolean hasShapeDisplayed(IFigure container) {
        int i = 0;
        while (i != this.visibleCompartments.size()) {
            IFigure compartment = this.visibleCompartments.get(i);
            if (compartment instanceof ScalableCompartmentFigure) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void layoutInvisibles(int x, int y) {
        for (IFigure child : this.invisibles) {
            Rectangle bound = new Rectangle(child.getBounds());
            bound.x = x;
            bound.y = y;
            child.setBounds(bound);
        }
    }

    protected void layoutOthers(Rectangle container) {
        int totalHeight = 0;
        for (IFigure child : this.visibleOthers) {
            totalHeight += child.getPreferredSize((int)50, (int)-1).height;
        }
        IFigure previous = null;
        for (IFigure child : this.visibleOthers) {
            Rectangle bound = new Rectangle();
            if (child instanceof WrappingLabel) {
                ((WrappingLabel)child).setTextJustification(2);
                bound.setSize(child.getPreferredSize(container.width, -1));
            } else {
                bound.setSize(this.getPreferedSize(child, container.width));
            }
            if (previous != null) {
                bound.y = previous.getBounds().getBottomLeft().y + 1;
                bound.x = container.x + 1;
                bound.width = container.width;
            } else {
                bound.x = container.x + 1;
                bound.y = (container.height - totalHeight) / 2 > 0 ? container.y + (container.height - totalHeight) / 2 : container.y;
                bound.width = container.width;
            }
            child.setBounds(bound);
            previous = child;
        }
    }

    private Dimension getPreferedSize(IFigure figure, int width) {
        Object compartment;
        Dimension dim = figure.getPreferredSize(width, -1);
        if (!figure.getChildren().isEmpty() && (compartment = figure.getChildren().get(0)) instanceof ResizableCompartmentFigure) {
            dim.height = ((ResizableCompartmentFigure)compartment).getPreferredSize((int)width, (int)-1).height + 10;
            if (dim.height < 15) {
                dim.height = 15;
            }
        }
        return dim;
    }

    protected void layoutDefault(IFigure container) {
        ArrayList<IFigure> visibles = new ArrayList<IFigure>();
        visibles.addAll(this.visibleOthers);
        visibles.addAll(this.visibleCompartments);
        List<Rectangle> bounds = this.buildInitialsBounds(container, visibles);
        double notCompartmentsHeight = this.getTotalHeight(bounds, 0, this.visibleOthers.size());
        double compartmentsHeight = this.getTotalHeight(bounds, this.visibleOthers.size(), this.visibleCompartments.size());
        double remainingspace = (double)container.getBounds().height - notCompartmentsHeight;
        remainingspace -= 3.0;
        double ratio = compartmentsHeight / (remainingspace -= (double)this.visibleCompartments.size());
        int i = 0;
        while (i != bounds.size()) {
            Rectangle bound = bounds.get(i);
            if (i < this.visibleOthers.size()) {
                this.fillBoundsForOther(container, bound, i == 0 ? null : bounds.get(i - 1));
            } else {
                this.fillBoundsForCompartment(container, bound, i == 0 ? null : bounds.get(i - 1), ratio);
            }
            ((IFigure)visibles.get(i)).setBounds(bound);
            ++i;
        }
    }

    protected void fillBoundsForCompartment(IFigure container, Rectangle bound, Rectangle previous, double ratio) {
        this.fillBoundsForOther(container, bound, previous);
        bound.height = (int)((double)bound.height / ratio);
        if (previous == null) {
            bound.y = container.getBounds().y;
        }
    }

    protected void fillBoundsForOther(IFigure container, Rectangle bound, Rectangle previous) {
        bound.x = container.getBounds().x + 1;
        bound.width = container.getBounds().width;
        bound.y = previous == null ? container.getBounds().y + 3 : previous.getBottomLeft().y + 1;
    }

    private double getTotalHeight(List<Rectangle> bounds, int startIndex, int count) {
        double result = 0.0;
        int i = startIndex;
        while (i != startIndex + count) {
            result += bounds.get(i).preciseHeight();
            ++i;
        }
        return result;
    }

    private List<Rectangle> buildInitialsBounds(IFigure container, List<IFigure> visibles) {
        ArrayList<Rectangle> result = new ArrayList<Rectangle>(visibles.size());
        for (IFigure child : visibles) {
            result.add(this.buildInitialsBounds(container, child));
        }
        return result;
    }

    private Rectangle buildInitialsBounds(IFigure container, IFigure child) {
        Rectangle bounds = new Rectangle(child.getBounds());
        child.invalidate();
        Dimension pref = child.getPreferredSize();
        child.invalidate();
        Dimension prefConstraint = child.getPreferredSize(container.getBounds().width - 40, -1);
        if (pref.width < prefConstraint.width) {
            bounds.setSize(pref);
        } else {
            bounds.setSize(prefConstraint);
        }
        return bounds;
    }

    protected void layoutForcedLabel(IFigure container) {
        container.getChildren().removeAll(this.visibleOthers);
        container.getChildren().addAll(this.visibleOthers);
        List<Rectangle> bounds = this.buildInitialsBounds(container, this.visibleCompartments);
        double compartmentsHeight = this.getTotalHeight(bounds, 0, this.visibleCompartments.size());
        double remainingspace = container.getBounds().height;
        double ratio = compartmentsHeight / (remainingspace -= (double)this.visibleCompartments.size());
        IFigure shapeCompartment = null;
        int i = 0;
        while (i != this.visibleCompartments.size()) {
            Rectangle bound = bounds.get(i);
            this.fillBoundsForCompartment(container, bound, i == 0 ? null : bounds.get(i - 1), ratio);
            IFigure compartment = this.visibleCompartments.get(i);
            compartment.setBounds(bound);
            if (compartment instanceof ScalableCompartmentFigure) {
                shapeCompartment = compartment;
            }
            ++i;
        }
        Rectangle otherBounds = container.getBounds();
        if (shapeCompartment != null) {
            otherBounds = ((SVGNodePlateFigure)container.getParent()).getLabelBounds(shapeCompartment.getBounds());
        }
        this.layoutOthers(otherBounds);
    }

    protected void collectInformation(IFigure container) {
        this.forcedLabelBounds = false;
        if (container.getParent() instanceof SVGNodePlateFigure) {
            this.forcedLabelBounds = ((SVGNodePlateFigure)container.getParent()).hasLabelBounds();
        }
        this.visibleCompartments.clear();
        this.visibleOthers.clear();
        this.invisibles.clear();
        for (Object o : container.getChildren()) {
            IFigure child = (IFigure)o;
            if (this.isGMFContainer(child)) {
                this.visibleCompartments.add(child);
                continue;
            }
            if (child instanceof Label || child instanceof WrappingLabel || child instanceof StereotypePropertiesCompartment) {
                this.visibleOthers.add(child);
                continue;
            }
            if (child instanceof ScalableCompartmentFigure || child instanceof ShapeCompartmentFigure) {
                this.visibleCompartments.add(child);
                continue;
            }
            this.invisibles.add(child);
        }
    }

    private boolean isGMFContainer(IFigure figure) {
        if (figure instanceof ResizableCompartmentFigure) {
            return true;
        }
        if (figure instanceof StereotypePropertiesCompartment) {
            return false;
        }
        return figure.getChildren().size() > 0 && figure.getChildren().get(0) instanceof ResizableCompartmentFigure;
    }
}

