/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library;

import com.google.common.collect.Iterables;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.evaluation.ModelManager;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.library.AbstractProperty;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public class ImplicitNonCompositionProperty
extends AbstractProperty {
    protected @NonNull Property property;

    public ImplicitNonCompositionProperty(@NonNull Property property) {
        this.property = property;
    }

    @Override
    public @Nullable Object evaluate(@NonNull Executor executor, @NonNull TypeId returnTypeId, @Nullable Object sourceValue) {
        if (sourceValue == null) {
            return null;
        }
        ModelManager.ModelManagerExtension2 modelManager = (ModelManager.ModelManagerExtension2)executor.getModelManager();
        Iterable<@NonNull Object> results = modelManager.getOpposite(this.property, sourceValue);
        if (this.property.isIsMany()) {
            return executor.getIdResolver().createCollectionOfAll(false, false, returnTypeId, results);
        }
        int size = Iterables.size(results);
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return results.iterator().next();
        }
        throw new InvalidValueException("Multiple opposites for " + this.property, new Object[0]);
    }
}

