/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.ui.actions;

import java.util.HashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ocl.examples.debug.ui.actions.DebugDialog;
import org.eclipse.ocl.examples.debug.ui.messages.DebugUIMessages;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.xtext.base.ui.utilities.BaseUIUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.handlers.HandlerUtil;

public class DebugHandler
extends AbstractHandler {
    public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
        Object applicationContext = event.getApplicationContext();
        @NonNull IWorkbenchSite site = HandlerUtil.getActiveSiteChecked((ExecutionEvent)event);
        IFile file = this.getFileFromEditorInput(HandlerUtil.getActiveEditorInputChecked((ExecutionEvent)event));
        if (file == null) {
            return null;
        }
        @NonNull ISelection currentSelection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        Object selectedObject = BaseUIUtil.getSelectedObject((ISelection)currentSelection, (IWorkbenchSite)site);
        if (!(selectedObject instanceof EObject)) {
            return null;
        }
        Object shell = HandlerUtil.getVariable((Object)applicationContext, (String)"activeShell");
        if (!(shell instanceof Shell)) {
            return null;
        }
        DebugDialog dialog = new DebugDialog((Shell)shell, (EObject)selectedObject);
        int open = dialog.open();
        if (open != 0) {
            return null;
        }
        EObject context = dialog.getContext();
        Constraint constraint = dialog.getConstraint();
        try {
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType("org.eclipse.ocl.examples.debug.launching.OCLLaunchConfigurationDelegate");
            String fileName = String.valueOf(file.getFullPath().lastSegment()) + ".launch";
            ILaunchConfigurationWorkingCopy launchConfiguration = launchConfigurationType.newInstance((IContainer)file.getProject(), fileName);
            ILaunchConfigurationWorkingCopy workingCopy = launchConfiguration.getWorkingCopy();
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("contextObject", context);
            attributes.put("expressionObject", constraint != null ? constraint.getOwnedSpecification() : null);
            workingCopy.setAttributes(attributes);
            workingCopy.launch("debug", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    private @Nullable IFile getFileFromEditorInput(IEditorInput editorInput) throws ExecutionException {
        IFile file = null;
        if (editorInput instanceof IFileEditorInput) {
            file = ((IFileEditorInput)editorInput).getFile();
        } else if (editorInput instanceof IStorageEditorInput) {
            try {
                IStorage storage = ((IStorageEditorInput)editorInput).getStorage();
                IPath path = storage.getFullPath();
                if (path != null) {
                    file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                }
            }
            catch (CoreException e) {
                throw new ExecutionException(DebugUIMessages.DebugHandler_0, (Throwable)e);
            }
        }
        return file;
    }
}

