/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.ShowMessageRequestParams;
import org.eclipse.mylyn.commons.notifications.ui.AbstractUiNotification;
import org.eclipse.mylyn.commons.notifications.ui.NotificationsUi;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class ServerMessageHandler {
    private static final String NAME_PATTERN = "%s (%s)";

    private ServerMessageHandler() {
    }

    public static void logMessage(LanguageServerWrapper wrapper, MessageParams params) {
        MessageConsole console = ServerMessageHandler.findConsole(String.format(NAME_PATTERN, wrapper.serverDefinition.label, wrapper.toString()));
        if (console != null) {
            StringBuilder log = new StringBuilder();
            log.append('[');
            log.append(params.getType().toString());
            log.append(']');
            log.append('\t');
            log.append(params.getMessage());
            MessageConsoleStream stream = console.newMessageStream();
            stream.println(log.toString());
            try {
                stream.close();
            }
            catch (IOException e) {
                LanguageServerPlugin.logError(e);
            }
        }
    }

    public static void showMessage(String title, MessageParams params) {
        LSPNotification notification = new LSPNotification(String.format("LSP (%s)", title), params);
        NotificationsUi.getService().notify(Collections.singletonList(notification));
    }

    public static CompletableFuture<MessageActionItem> showMessageRequest(LanguageServerWrapper wrapper, ShowMessageRequestParams params) {
        String[] options = (String[])params.getActions().stream().map(MessageActionItem::getTitle).toArray(String[]::new);
        CompletableFuture<MessageActionItem> future = new CompletableFuture<MessageActionItem>();
        Display.getDefault().asyncExec(() -> {
            Shell shell = new Shell(Display.getCurrent());
            MessageDialog dialog = new MessageDialog(shell, languageServerWrapper.serverDefinition.label, null, params.getMessage(), 2, 0, options);
            MessageActionItem result = new MessageActionItem();
            int dialogResult = dialog.open();
            if (dialogResult != -1) {
                result.setTitle(options[dialogResult]);
            }
            future.complete(result);
        });
        return future;
    }

    private static MessageConsole findConsole(String name) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        MessageConsole myConsole = new MessageConsole(name, "org.eclipse.ui.MessageConsole", null, StandardCharsets.UTF_8.name(), true);
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }

    private static class LSPNotification
    extends AbstractUiNotification {
        private final String label;
        private final MessageParams messageParams;

        public LSPNotification(String label, MessageParams messageParams) {
            super("lsp.notification");
            this.label = label;
            this.messageParams = messageParams;
        }

        public String getLabel() {
            return this.label;
        }

        public String getDescription() {
            return this.messageParams.getMessage();
        }

        public Date getDate() {
            return new Date();
        }

        public <T> T getAdapter(Class<T> adapter) {
            return null;
        }

        public Image getNotificationImage() {
            return null;
        }

        public Image getNotificationKindImage() {
            switch (this.messageParams.getType()) {
                case Error: {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
                }
                case Warning: {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
                }
                case Info: {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
                }
            }
            return null;
        }

        public void open() {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            switch (this.messageParams.getType()) {
                case Error: {
                    MessageDialog.openError((Shell)shell, (String)this.label, (String)this.messageParams.getMessage());
                    break;
                }
                case Warning: {
                    MessageDialog.openWarning((Shell)shell, (String)this.label, (String)this.messageParams.getMessage());
                    break;
                }
                case Info: {
                    MessageDialog.openInformation((Shell)shell, (String)this.label, (String)this.messageParams.getMessage());
                    break;
                }
                default: {
                    MessageDialog.open((int)0, (Shell)shell, (String)this.label, (String)this.messageParams.getMessage(), (int)0);
                }
            }
        }
    }
}

