/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.section;

import java.util.ArrayList;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jst.jsf.facesconfig.emf.ApplicationType;
import org.eclipse.jst.jsf.facesconfig.emf.DefaultLocaleType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.LocaleConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.SupportedLocaleType;
import org.eclipse.jst.jsf.facesconfig.ui.dialog.DialogUtil;
import org.eclipse.jst.jsf.facesconfig.ui.page.IFacesConfigPage;
import org.eclipse.jst.jsf.facesconfig.ui.page.OthersPage;
import org.eclipse.jst.jsf.facesconfig.ui.section.ApplicationSection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class LocaleConfigSection
extends ApplicationSection
implements ICheckStateListener {
    private LocaleConfigAdapter _localeConfigAdapter;

    public LocaleConfigSection(EClass componentClass, Composite parent, IManagedForm managedForm, IFacesConfigPage page, FormToolkit toolkit, String helpContextId, String helpTooltip) {
        super(componentClass, parent, managedForm, page, toolkit, helpContextId, helpTooltip);
    }

    public LocaleConfigSection(EClass componentClass, Composite parent, IManagedForm managedForm, IFacesConfigPage page, FormToolkit toolkit) {
        this(componentClass, parent, managedForm, page, toolkit, null, null);
    }

    public void dispose() {
        ((CheckboxTableViewer)this.tableViewer).removeCheckStateListener((ICheckStateListener)this);
        super.dispose();
    }

    protected TableViewer createTableViewer(Composite parent) {
        CheckboxTableViewer tableViewer1 = CheckboxTableViewer.newCheckList((Composite)parent, (int)2818);
        tableViewer1.addCheckStateListener((ICheckStateListener)this);
        tableViewer1.setSorter(new ViewerSorter());
        return tableViewer1;
    }

    protected void configTableViewer(TableViewer tableViewer1) {
        tableViewer1.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return FacesConfigPackage.eINSTANCE.getSupportedLocaleType().isInstance(element) || FacesConfigPackage.eINSTANCE.getDefaultLocaleType().isInstance(element);
            }
        });
    }

    public SupportedLocaleType createSupportedLocaleObject() {
        String result;
        ArrayList<String> locales = new ArrayList<String>();
        if (this.getInput() instanceof ApplicationType && ((ApplicationType)this.getInput()).getLocaleConfig().size() > 0) {
            String locale;
            LocaleConfigType localeConfigType = (LocaleConfigType)((ApplicationType)this.getInput()).getLocaleConfig().get(0);
            if (localeConfigType.getDefaultLocale() != null && (locale = localeConfigType.getDefaultLocale().getTextContent()) != null) {
                locales.add(locale);
            }
            EList list = localeConfigType.getSupportedLocale();
            int i = 0;
            int n = list.size();
            while (i < n) {
                String locale2 = ((SupportedLocaleType)list.get(i)).getTextContent();
                if (locale2 != null) {
                    locales.add(locale2);
                }
                ++i;
            }
        }
        if ((result = DialogUtil.openLocaleDialog(this.getSection().getShell(), locales)) != null) {
            SupportedLocaleType component = FacesConfigFactory.eINSTANCE.createSupportedLocaleType();
            component.setTextContent(result);
            return component;
        }
        return null;
    }

    void addButtonSelected(SelectionEvent e) {
        SupportedLocaleType obj = this.createSupportedLocaleObject();
        if (obj != null) {
            boolean needRefreshAll = false;
            Command command = null;
            if (this.getInput() instanceof ApplicationType) {
                ApplicationType application = (ApplicationType)this.getInput();
                if (application.getLocaleConfig().size() > 0) {
                    LocaleConfigType localeConfig = (LocaleConfigType)application.getLocaleConfig().get(0);
                    command = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)localeConfig, null, (Object)obj);
                } else {
                    LocaleConfigType localeConfig = FacesConfigFactory.eINSTANCE.createLocaleConfigType();
                    localeConfig.getSupportedLocale().add((Object)obj);
                    command = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)application, null, (Object)localeConfig);
                }
            } else {
                needRefreshAll = true;
                ApplicationType application = FacesConfigFactory.eINSTANCE.createApplicationType();
                LocaleConfigType localeConfig = FacesConfigFactory.eINSTANCE.createLocaleConfigType();
                localeConfig.getSupportedLocale().add((Object)obj);
                application.getLocaleConfig().add((Object)localeConfig);
                command = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getPage().getInput(), null, (Object)application);
            }
            if (command.canExecute()) {
                this.getEditingDomain().getCommandStack().execute(command);
                if (needRefreshAll) {
                    ((OthersPage)this.getPage()).resetApplicationInput();
                }
            }
        }
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        boolean checked = event.getChecked();
        if (event.getElement() == null) {
            return;
        }
        EObject node = (EObject)event.getElement();
        LocaleConfigType localeConfigType = (LocaleConfigType)((ApplicationType)this.getInput()).getLocaleConfig().get(0);
        CompoundCommand compoundCommand = new CompoundCommand();
        if (checked) {
            if (localeConfigType.getDefaultLocale() != null) {
                Command command = RemoveCommand.create((EditingDomain)this.getEditingDomain(), (Object)localeConfigType, null, (Object)localeConfigType.getDefaultLocale());
                compoundCommand.append(command);
                SupportedLocaleType supportedLocale = FacesConfigFactory.eINSTANCE.createSupportedLocaleType();
                supportedLocale.setTextContent(localeConfigType.getDefaultLocale().getTextContent());
                command = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)localeConfigType, (Object)FacesConfigPackage.eINSTANCE.getLocaleConfigType_SupportedLocale(), (Object)supportedLocale);
                compoundCommand.append(command);
            }
            SupportedLocaleType supportedLocale = (SupportedLocaleType)node;
            Command command = RemoveCommand.create((EditingDomain)this.getEditingDomain(), (Object)localeConfigType, (Object)FacesConfigPackage.eINSTANCE.getLocaleConfigType_SupportedLocale(), (Object)supportedLocale);
            compoundCommand.append(command);
            DefaultLocaleType defaultLocale = FacesConfigFactory.eINSTANCE.createDefaultLocaleType();
            defaultLocale.setTextContent(supportedLocale.getTextContent());
            command = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)localeConfigType, (Object)FacesConfigPackage.eINSTANCE.getLocaleConfigType_DefaultLocale(), (Object)defaultLocale);
            compoundCommand.append(command);
        } else {
            DefaultLocaleType defaultLocale = (DefaultLocaleType)node;
            Command command = RemoveCommand.create((EditingDomain)this.getEditingDomain(), (Object)localeConfigType, null, (Object)defaultLocale);
            compoundCommand.append(command);
            SupportedLocaleType supportedLocale = FacesConfigFactory.eINSTANCE.createSupportedLocaleType();
            supportedLocale.setTextContent(defaultLocale.getTextContent());
            command = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)localeConfigType, null, (Object)supportedLocale);
            compoundCommand.append(command);
        }
        if (compoundCommand.canExecute()) {
            this.getEditingDomain().getCommandStack().execute((Command)compoundCommand);
            this.refresh();
            this.setTableViewerCheckedState();
        }
    }

    private void setTableViewerCheckedState() {
        LocaleConfigType localeConfigType;
        ApplicationType application;
        if (this.getInput() instanceof ApplicationType && (application = (ApplicationType)this.getInput()).getLocaleConfig().size() > 0 && (localeConfigType = (LocaleConfigType)application.getLocaleConfig().get(0)).getDefaultLocale() != null) {
            ((CheckboxTableViewer)this.getTableViewer()).setChecked((Object)localeConfigType.getDefaultLocale(), true);
        }
    }

    protected void addAdaptersOntoInput(Object input) {
        ApplicationType application;
        super.addAdaptersOntoInput(input);
        if (input != null && input instanceof ApplicationType && EcoreUtil.getExistingAdapter((Notifier)(application = (ApplicationType)input), LocaleConfigSection.class) == null) {
            application.eAdapters().add((Object)this.getLocaleConfigAdapter());
        }
    }

    private Adapter getLocaleConfigAdapter() {
        if (this._localeConfigAdapter == null) {
            this._localeConfigAdapter = new LocaleConfigAdapter();
        }
        return this._localeConfigAdapter;
    }

    protected void removeAdaptersFromInput(Object input) {
        if (input != null && input instanceof ApplicationType && this._localeConfigAdapter != null) {
            ApplicationType application = (ApplicationType)input;
            application.eAdapters().remove((Object)this._localeConfigAdapter);
        }
        super.removeAdaptersFromInput(input);
    }

    protected void setViewerInput(Object input) {
        if (input instanceof ApplicationType) {
            ApplicationType application = (ApplicationType)input;
            if (application.getLocaleConfig().size() > 0) {
                this.tableViewer.setInput(application.getLocaleConfig().get(0));
            } else {
                this.tableViewer.setInput(null);
            }
        } else {
            this.tableViewer.setInput(null);
        }
    }

    public void refreshAll() {
        super.refreshAll();
        this.setTableViewerCheckedState();
    }

    class LocaleConfigAdapter
    extends AdapterImpl {
        LocaleConfigAdapter() {
        }

        public boolean isAdapterForType(Object type) {
            return type == LocaleConfigSection.class;
        }

        public void notifyChanged(Notification msg) {
            if ((msg.getEventType() == 3 || msg.getEventType() == 4) && msg.getFeature() == FacesConfigPackage.eINSTANCE.getApplicationType_LocaleConfig()) {
                if (Thread.currentThread() == PlatformUI.getWorkbench().getDisplay().getThread()) {
                    LocaleConfigSection.this.setInput(LocaleConfigSection.this.getInput());
                } else {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            LocaleConfigSection.this.setInput(LocaleConfigSection.this.getInput());
                        }
                    });
                }
            }
        }
    }
}

