/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit5.runner;

import java.util.ArrayList;
import org.eclipse.jdt.internal.junit.runner.ITestLoader;
import org.eclipse.jdt.internal.junit.runner.ITestReference;
import org.eclipse.jdt.internal.junit.runner.RemoteTestRunner;
import org.eclipse.jdt.internal.junit5.runner.JUnit5TestReference;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.discovery.ClassNameFilter;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.PostDiscoveryFilter;
import org.junit.platform.launcher.TagFilter;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;

public class JUnit5TestLoader
implements ITestLoader {
    private Launcher fLauncher = LauncherFactory.create();
    private RemoteTestRunner fRemoteTestRunner;

    public ITestReference[] loadTests(Class<?>[] testClasses, String testName, String[] failureNames, String[] packages, String[][] includeExcludeTags, String uniqueId, RemoteTestRunner listener) {
        this.fRemoteTestRunner = listener;
        ITestReference[] refs = new ITestReference[]{};
        if (uniqueId != null && !uniqueId.trim().isEmpty()) {
            refs = new ITestReference[]{this.createUniqueIdTest(uniqueId, includeExcludeTags)};
        } else if (packages != null) {
            refs = new ITestReference[packages.length];
            int i = 0;
            while (i < packages.length) {
                refs[i] = this.createTest(packages[i], includeExcludeTags);
                ++i;
            }
        } else {
            refs = new ITestReference[testClasses.length];
            int i = 0;
            while (i < testClasses.length) {
                refs[i] = this.createTest(testClasses[i], testName, includeExcludeTags);
                ++i;
            }
        }
        return refs;
    }

    private ITestReference createTest(Class<?> clazz, String testName, String[][] includeExcludeTags) {
        if (clazz == null) {
            return null;
        }
        if (testName != null) {
            return this.createFilteredTest(clazz, testName, includeExcludeTags);
        }
        return this.createUnfilteredTest(clazz, includeExcludeTags);
    }

    private ITestReference createFilteredTest(Class<?> clazz, String testName, String[][] includeExcludeTags) {
        LauncherDiscoveryRequest request = LauncherDiscoveryRequestBuilder.request().selectors(new DiscoverySelector[]{DiscoverySelectors.selectMethod((String)(String.valueOf(clazz.getName()) + "#" + testName))}).filters(this.getTagFilters(includeExcludeTags)).build();
        return new JUnit5TestReference(request, this.fLauncher, this.fRemoteTestRunner);
    }

    private ITestReference createUnfilteredTest(Class<?> clazz, String[][] includeExcludeTags) {
        LauncherDiscoveryRequest request = LauncherDiscoveryRequestBuilder.request().selectors(new DiscoverySelector[]{DiscoverySelectors.selectClass(clazz)}).filters(this.getTagFilters(includeExcludeTags)).build();
        return new JUnit5TestReference(request, this.fLauncher, this.fRemoteTestRunner);
    }

    private ITestReference createTest(String pkg, String[][] includeExcludeTags) {
        String pattern;
        if (pkg == null) {
            return null;
        }
        if (pkg.equals("<default>")) {
            pkg = "";
            pattern = "^[^.]+$";
        } else {
            pattern = "^" + pkg + "\\.[^.]+$";
        }
        LauncherDiscoveryRequest request = LauncherDiscoveryRequestBuilder.request().selectors(new DiscoverySelector[]{DiscoverySelectors.selectPackage((String)pkg)}).filters(new Filter[]{ClassNameFilter.includeClassNamePatterns((String[])new String[]{pattern})}).filters(this.getTagFilters(includeExcludeTags)).build();
        return new JUnit5TestReference(request, this.fLauncher, this.fRemoteTestRunner);
    }

    private ITestReference createUniqueIdTest(String uniqueId, String[][] includeExcludeTags) {
        LauncherDiscoveryRequest request = LauncherDiscoveryRequestBuilder.request().selectors(new DiscoverySelector[]{DiscoverySelectors.selectUniqueId((String)uniqueId)}).filters(this.getTagFilters(includeExcludeTags)).build();
        return new JUnit5TestReference(request, this.fLauncher, this.fRemoteTestRunner);
    }

    private Filter<?>[] getTagFilters(String[][] includeExcludeTags) {
        String[] includeTags = includeExcludeTags[0];
        String[] excludeTags = includeExcludeTags[1];
        ArrayList<PostDiscoveryFilter> tagFilters = new ArrayList<PostDiscoveryFilter>();
        if (includeTags != null) {
            tagFilters.add(TagFilter.includeTags((String[])includeTags));
        }
        if (excludeTags != null) {
            tagFilters.add(TagFilter.excludeTags((String[])excludeTags));
        }
        return tagFilters.toArray(new Filter[tagFilters.size()]);
    }
}

