/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.logging.aeri.core.l10n;

import static org.eclipse.core.runtime.IStatus.WARNING;

import org.eclipse.epp.logging.aeri.core.util.Logs.DefaultLogMessage;
import org.eclipse.epp.logging.aeri.core.util.Logs.ILogMessage;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

@SuppressWarnings("null")
public final class LogMessages extends DefaultLogMessage {

    public static final Bundle BUNDLE = FrameworkUtil.getBundle(LogMessages.class);
    // Unit tests should not fails because OSGI is not yet available:
    private static final String VERSION = "; version: " //$NON-NLS-1$
            + (BUNDLE == null ? "unit-tests" : BUNDLE.getVersion().toString());
    private static int code = 1;

    public static final LogMessages WARN_AERI_FAILURE = new LogMessages(WARNING, Messages.LOG_WARN_AERI_FAILURE);
    public static final LogMessages WARN_CYCLIC_EXCEPTION = new LogMessages(WARNING, Messages.LOG_WARN_CYCLIC_EXCEPTION);
    public static final ILogMessage WARN_SERVER_FAILURE = new LogMessages(WARNING, Messages.LOG_WARN_SERVER_FAILURE);

    public LogMessages(int severity, String message) {
        super(severity, code++, String.format("%s %s", message, VERSION)); //$NON-NLS-1$
    }

    public LogMessages(int severity, int code, String message) {
        super(severity, code, String.format("%s %s", message, VERSION)); //$NON-NLS-1$
    }

    @Override
    public Bundle bundle() {
        return BUNDLE;
    }
}
