/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication.verifiers;

import java.io.IOException;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.emfstore.internal.common.APIUtil;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.ServerConfiguration;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.AccessControl;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication.verifiers.UserVerifier;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.server.auth.ESPasswordHashGenerator;
import org.eclipse.emf.emfstore.server.model.ESOrgUnitProvider;

public class EMFModelUserVerifier
extends UserVerifier {
    public EMFModelUserVerifier(ESOrgUnitProvider orgUnitProvider) {
        super(orgUnitProvider);
        this.migrateToHashedPasswordIfNeeded(orgUnitProvider);
    }

    private void migrateToHashedPasswordIfNeeded(ESOrgUnitProvider orgUnitProvider) {
        if (!ServerConfiguration.isUserPasswordMigrationRequired()) {
            return;
        }
        ESPasswordHashGenerator passwordHashGenerator = AccessControl.getESPasswordHashGenerator();
        Set users = APIUtil.toInternal((Set)orgUnitProvider.getUsers());
        for (ACUser user : users) {
            if (user.getPassword() == null) continue;
            ESPasswordHashGenerator.ESHashAndSalt hashAndSalt = passwordHashGenerator.hashPassword(user.getPassword());
            user.setPassword(String.valueOf(hashAndSalt.getHash()) + " " + hashAndSalt.getSalt());
        }
        try {
            orgUnitProvider.save();
        }
        catch (IOException ex) {
            ModelUtil.logException((String)"Migration of user passwords failed", (Throwable)ex);
        }
    }

    protected boolean verifyPassword(String username, String password) throws AccessControlException {
        ACUser resolvedUser = this.findUser(username);
        if (resolvedUser == null) {
            return false;
        }
        String userPassword = resolvedUser.getPassword();
        if (userPassword == null) {
            return StringUtils.isBlank((String)password);
        }
        ESPasswordHashGenerator passwordHashGenerator = AccessControl.getESPasswordHashGenerator();
        int separatorIndex = userPassword.indexOf(" ");
        String hash = userPassword.substring(0, separatorIndex);
        String salt = userPassword.substring(separatorIndex + 1);
        return passwordHashGenerator.verifyPassword(password, hash, salt);
    }

    public void init(ESOrgUnitProvider orgUnitProvider) {
    }
}

