/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.CDOCommonSession;
import org.eclipse.emf.cdo.common.branch.CDOBranchChangedEvent;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lock.CDOLockChangeInfo;
import org.eclipse.emf.cdo.common.protocol.CDOProtocol;
import org.eclipse.emf.cdo.common.util.NotAuthenticatedException;
import org.eclipse.emf.cdo.internal.server.Session;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.IPermissionManager;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.session.remote.CDORemoteSessionMessage;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.server.IAuthenticationProtocol;
import org.eclipse.emf.cdo.spi.server.ISessionProtocol;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.security.CredentialsUpdateOperation;
import org.eclipse.net4j.util.security.DiffieHellman;
import org.eclipse.net4j.util.security.IAuthenticator;
import org.eclipse.net4j.util.security.IAuthenticator2;
import org.eclipse.net4j.util.security.IUserManager;
import org.eclipse.net4j.util.security.UserManagerAuthenticator;

public class SessionManager
extends Container<ISession>
implements InternalSessionManager {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_SESSION, SessionManager.class);
    private InternalRepository repository;
    private DiffieHellman.Server authenticationServer;
    private IAuthenticator authenticator;
    private IPermissionManager permissionManager;
    private final Map<Integer, InternalSession> sessions = new HashMap<Integer, InternalSession>();
    private final AtomicInteger lastSessionID = new AtomicInteger();
    private final Map<InternalSession, List<CDOProtocol.CommitNotificationInfo>> commitNotificationInfoQueues = new HashMap<InternalSession, List<CDOProtocol.CommitNotificationInfo>>();
    private final IListener sessionListener = new LifecycleEventAdapter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onDeactivated(ILifecycle lifecycle) {
            Map map = SessionManager.this.commitNotificationInfoQueues;
            synchronized (map) {
                SessionManager.this.commitNotificationInfoQueues.remove(lifecycle);
            }
        }
    };

    @Override
    public InternalRepository getRepository() {
        return this.repository;
    }

    @Override
    public void setRepository(InternalRepository repository) {
        this.checkInactive();
        this.repository = repository;
    }

    @Override
    @Deprecated
    public IUserManager getUserManager() {
        if (this.authenticator instanceof UserManagerAuthenticator) {
            return ((UserManagerAuthenticator)this.authenticator).getUserManager();
        }
        return null;
    }

    @Override
    @Deprecated
    public void setUserManager(IUserManager userManager) {
        UserManagerAuthenticator userManagerAuthenticator = new UserManagerAuthenticator();
        userManagerAuthenticator.setUserManager(userManager);
        this.setAuthenticator((IAuthenticator)userManagerAuthenticator);
    }

    @Override
    public DiffieHellman.Server getAuthenticationServer() {
        return this.authenticationServer;
    }

    @Override
    public void setAuthenticationServer(DiffieHellman.Server authenticationServer) {
        this.authenticationServer = authenticationServer;
    }

    @Override
    public IAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    @Override
    public void setAuthenticator(IAuthenticator authenticator) {
        this.authenticator = authenticator;
        if (this.isActive() && authenticator != null) {
            this.initAuthentication();
        }
    }

    @Override
    public IPermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    @Override
    public void setPermissionManager(IPermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalSession[] getSessions() {
        Map<Integer, InternalSession> map = this.sessions;
        synchronized (map) {
            return this.sessions.values().toArray(new InternalSession[this.sessions.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalSession getSession(int sessionID) {
        this.checkActive();
        Map<Integer, InternalSession> map = this.sessions;
        synchronized (map) {
            return this.sessions.get(sessionID);
        }
    }

    public InternalSession[] getElements() {
        return this.getSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Map<Integer, InternalSession> map = this.sessions;
        synchronized (map) {
            return this.sessions.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalSession openSession(ISessionProtocol sessionProtocol) {
        final int id = this.lastSessionID.incrementAndGet();
        if (TRACER.isEnabled()) {
            TRACER.trace("Opening session " + id);
        }
        String userID = this.authenticateUser(sessionProtocol);
        final InternalSession session = this.createSession(id, userID, sessionProtocol);
        LifecycleUtil.activate((Object)session);
        Map<Integer, InternalSession> map = this.sessions;
        synchronized (map) {
            this.repository.executeOutsideStartCommit(new Runnable(){

                @Override
                public void run() {
                    long firstUpdateTime = SessionManager.this.repository.getLastCommitTimeStamp();
                    session.setFirstUpdateTime(firstUpdateTime);
                    SessionManager.this.sessions.put(id, session);
                }
            });
        }
        this.fireElementAddedEvent(session);
        this.sendRemoteSessionNotification(session, (byte)1);
        return session;
    }

    protected InternalSession createSession(int id, String userID, ISessionProtocol protocol) {
        return new Session(this, protocol, id, userID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sessionClosed(InternalSession session) {
        int sessionID = session.getSessionID();
        InternalSession removeSession = null;
        Map<Integer, InternalSession> map = this.sessions;
        synchronized (map) {
            removeSession = this.sessions.remove(sessionID);
        }
        if (removeSession != null) {
            this.fireElementRemovedEvent(session);
            this.sendRemoteSessionNotification(session, (byte)2);
        }
    }

    @Override
    public void openedOnClientSide(InternalSession session) {
        this.processQueuedCommitNotifications(session);
    }

    @Override
    public void sendRepositoryTypeNotification(CDOCommonRepository.Type oldType, CDOCommonRepository.Type newType) {
        InternalSession[] internalSessionArray = this.getSessions();
        int n = internalSessionArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalSession session = internalSessionArray[n2];
            try {
                session.sendRepositoryTypeNotification(oldType, newType);
            }
            catch (Exception ex) {
                this.handleNotificationProblem(session, ex);
            }
            ++n2;
        }
    }

    @Override
    @Deprecated
    public void sendRepositoryStateNotification(CDOCommonRepository.State oldState, CDOCommonRepository.State newState) {
        this.sendRepositoryStateNotification(oldState, newState, null);
    }

    @Override
    public void sendRepositoryStateNotification(CDOCommonRepository.State oldState, CDOCommonRepository.State newState, CDOID rootResourceID) {
        InternalSession[] internalSessionArray = this.getSessions();
        int n = internalSessionArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalSession session = internalSessionArray[n2];
            try {
                session.sendRepositoryStateNotification(oldState, newState, rootResourceID);
            }
            catch (Exception ex) {
                this.handleNotificationProblem(session, ex);
            }
            ++n2;
        }
    }

    @Override
    @Deprecated
    public void sendBranchNotification(InternalSession sender, InternalCDOBranch branch) {
        this.sendBranchNotification(sender, branch, CDOBranchChangedEvent.ChangeKind.CREATED);
    }

    @Override
    public void sendBranchNotification(InternalSession sender, InternalCDOBranch branch, CDOBranchChangedEvent.ChangeKind changeKind) {
        InternalSession[] internalSessionArray = this.getSessions();
        int n = internalSessionArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalSession session = internalSessionArray[n2];
            if (session != sender) {
                try {
                    session.sendBranchNotification(branch, changeKind);
                }
                catch (Exception ex) {
                    this.handleNotificationProblem(session, ex);
                }
            }
            ++n2;
        }
    }

    @Override
    @Deprecated
    public void sendCommitNotification(InternalSession sender, CDOCommitInfo commitInfo) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void sendCommitNotification(InternalSession sender, CDOCommitInfo commitInfo, boolean clearResourcePathCache) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sendCommitNotification(CDOProtocol.CommitNotificationInfo info) {
        CDOCommonSession sender = info.getSender();
        InternalSession[] internalSessionArray = this.getSessions();
        int n = internalSessionArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalSession session = internalSessionArray[n2];
            if (session != sender || info.isModifiedByServer()) {
                if (session.isOpenOnClientSide()) {
                    this.processQueuedCommitNotifications(session);
                    this.doSendCommitNotification(session, info);
                } else {
                    this.queueCommitNotification(session, info);
                }
            }
            ++n2;
        }
    }

    private void doSendCommitNotification(InternalSession session, CDOProtocol.CommitNotificationInfo info) {
        try {
            session.sendCommitNotification(info);
        }
        catch (Exception ex) {
            this.handleNotificationProblem(session, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueCommitNotification(InternalSession session, CDOProtocol.CommitNotificationInfo info) {
        Map<InternalSession, List<CDOProtocol.CommitNotificationInfo>> map = this.commitNotificationInfoQueues;
        synchronized (map) {
            List<CDOProtocol.CommitNotificationInfo> queue = this.commitNotificationInfoQueues.get(session);
            if (queue == null) {
                queue = new ArrayList<CDOProtocol.CommitNotificationInfo>();
                this.commitNotificationInfoQueues.put(session, queue);
                session.addListener(this.sessionListener);
            }
            queue.add(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processQueuedCommitNotifications(InternalSession session) {
        List<CDOProtocol.CommitNotificationInfo> queue;
        Map<InternalSession, List<CDOProtocol.CommitNotificationInfo>> map = this.commitNotificationInfoQueues;
        synchronized (map) {
            queue = this.commitNotificationInfoQueues.remove(session);
        }
        if (queue != null && !session.isClosed()) {
            session.removeListener(this.sessionListener);
            for (CDOProtocol.CommitNotificationInfo queuedInfo : queue) {
                this.doSendCommitNotification(session, queuedInfo);
            }
        }
    }

    @Override
    public void sendLockNotification(InternalSession sender, CDOLockChangeInfo lockChangeInfo) {
        InternalSession[] internalSessionArray = this.getSessions();
        int n = internalSessionArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalSession session = internalSessionArray[n2];
            if (session != sender && session.options().getLockNotificationMode() != CDOCommonSession.Options.LockNotificationMode.OFF) {
                try {
                    session.sendLockNotification(lockChangeInfo);
                }
                catch (Exception ex) {
                    this.handleNotificationProblem(session, ex);
                }
            }
            ++n2;
        }
    }

    @Override
    public void sendRemoteSessionNotification(InternalSession sender, byte opcode) {
        try {
            InternalSession[] internalSessionArray = this.getSessions();
            int n = internalSessionArray.length;
            int n2 = 0;
            while (n2 < n) {
                InternalSession session = internalSessionArray[n2];
                if (session != sender && session.isSubscribed()) {
                    try {
                        session.sendRemoteSessionNotification(sender, opcode);
                    }
                    catch (Exception ex) {
                        this.handleNotificationProblem(session, ex);
                    }
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            OM.LOG.warn("A problem occured while notifying other sessions", (Throwable)ex);
        }
    }

    @Override
    public List<Integer> sendRemoteMessageNotification(InternalSession sender, CDORemoteSessionMessage message, int[] recipients) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int i = 0;
        while (i < recipients.length) {
            InternalSession recipient = this.getSession(recipients[i]);
            try {
                if (recipient != null && recipient.isSubscribed()) {
                    recipient.sendRemoteMessageNotification(sender, message);
                    result.add(recipient.getSessionID());
                }
            }
            catch (Exception ex) {
                this.handleNotificationProblem(recipient, ex);
            }
            ++i;
        }
        return result;
    }

    protected void handleNotificationProblem(InternalSession session, Throwable t) {
        if (session.isClosed()) {
            if (TRACER.isEnabled()) {
                TRACER.trace("A problem occured while notifying session " + session, t);
            }
        } else {
            OM.LOG.warn("A problem occured while notifying session " + session, t);
        }
    }

    @Override
    public String authenticateUser(IAuthenticationProtocol protocol) throws SecurityException {
        if (protocol == null) {
            return null;
        }
        if (this.authenticationServer == null || this.authenticator == null) {
            return null;
        }
        try {
            DiffieHellman.Server.Challenge challenge = this.authenticationServer.getChallenge();
            DiffieHellman.Client.Response response = protocol.sendAuthenticationChallenge(challenge);
            if (response == null) {
                throw this.notAuthenticated();
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(this.authenticationServer.handleResponse(response));
            ExtendedDataInputStream stream = new ExtendedDataInputStream((InputStream)bais);
            String userID = stream.readString();
            char[] password = stream.readString().toCharArray();
            this.authenticator.authenticate(userID, password);
            return userID;
        }
        catch (SecurityException ex) {
            throw ex;
        }
        catch (Exception ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof SecurityException) {
                throw (SecurityException)cause;
            }
            throw new SecurityException(ex);
        }
    }

    @Override
    public void changeUserCredentials(IAuthenticationProtocol sessionProtocol, String userID) {
        this.changeUserCredentials(sessionProtocol, userID, CredentialsUpdateOperation.CHANGE_PASSWORD);
    }

    @Override
    public void resetUserCredentials(IAuthenticationProtocol sessionProtocol, String userID) {
        this.changeUserCredentials(sessionProtocol, userID, CredentialsUpdateOperation.RESET_PASSWORD);
    }

    protected void changeUserCredentials(IAuthenticationProtocol sessionProtocol, String userID, CredentialsUpdateOperation operation) {
        if (sessionProtocol == null) {
            return;
        }
        if (this.authenticationServer == null || this.authenticator == null) {
            return;
        }
        if (!(this.authenticator instanceof IAuthenticator2)) {
            throw new SecurityException("Current authenticator does not permit password updates");
        }
        try {
            DiffieHellman.Server.Challenge challenge = this.authenticationServer.getChallenge();
            DiffieHellman.Client.Response response = sessionProtocol.sendCredentialsChallenge(challenge, userID, operation);
            if (response == null) {
                throw this.notAuthenticated();
            }
            ByteArrayInputStream baos = new ByteArrayInputStream(this.authenticationServer.handleResponse(response));
            ExtendedDataInputStream stream = new ExtendedDataInputStream((InputStream)baos);
            if (operation == CredentialsUpdateOperation.RESET_PASSWORD) {
                String adminID = stream.readString();
                char[] adminPassword = stream.readString().toCharArray();
                if (!ObjectUtil.equals((Object)userID, (Object)stream.readString())) {
                    throw new SecurityException("Attempt to reset password of a different user than requested");
                }
                char[] newPassword = stream.readString().toCharArray();
                ((IAuthenticator2)this.authenticator).resetPassword(adminID, adminPassword, userID, newPassword);
            } else {
                userID = stream.readString();
                char[] password = stream.readString().toCharArray();
                char[] newPassword = stream.readString().toCharArray();
                ((IAuthenticator2)this.authenticator).updatePassword(userID, password, newPassword);
            }
        }
        catch (SecurityException ex) {
            throw ex;
        }
        catch (Exception ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof SecurityException) {
                throw (SecurityException)cause;
            }
            throw new SecurityException(ex);
        }
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.initAuthentication();
    }

    protected void initAuthentication() {
        if (this.authenticator != null) {
            if (this.authenticationServer == null) {
                this.authenticationServer = new DiffieHellman.Server(this.repository.getUUID());
            }
            LifecycleUtil.activate((Object)this.authenticationServer);
            LifecycleUtil.activate((Object)this.authenticator);
        }
    }

    protected void doDeactivate() throws Exception {
        LifecycleUtil.deactivate((Object)this.authenticator);
        LifecycleUtil.deactivate((Object)this.authenticationServer);
        InternalSession[] internalSessionArray = this.getSessions();
        int n = internalSessionArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalSession session = internalSessionArray[n2];
            LifecycleUtil.deactivate((Object)session);
            ++n2;
        }
        super.doDeactivate();
    }

    private SecurityException notAuthenticated() {
        return new NotAuthenticatedException();
    }
}

