/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.gitflow.op;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egit.gitflow.GitFlowRepository;
import org.eclipse.egit.gitflow.WrongGitFlowStateException;
import org.eclipse.egit.gitflow.internal.CoreText;
import org.eclipse.egit.gitflow.op.AbstractVersionFinishOperation;

public abstract class AbstractReleaseOperation
extends AbstractVersionFinishOperation {
    public AbstractReleaseOperation(GitFlowRepository repository, String releaseName) {
        super(repository, releaseName);
    }

    protected static String getReleaseName(GitFlowRepository repository) throws WrongGitFlowStateException, CoreException, IOException {
        String currentBranch = repository.getRepository().getBranch();
        if (currentBranch == null || !repository.isRelease()) {
            throw new WrongGitFlowStateException(CoreText.AbstractReleaseOperation_notOnAReleaseBranch);
        }
        return currentBranch.substring(repository.getConfig().getReleasePrefix().length());
    }
}

