/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IPatternMatchListenerDelegate;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;

public class ErrorLineMatcher
implements IPatternMatchListenerDelegate {
    private TextConsole console;

    public void connect(TextConsole console) {
        this.console = console;
    }

    public void disconnect() {
        this.console = null;
    }

    public void matchFound(PatternMatchEvent event) {
        try {
            int offset = event.getOffset();
            int length = event.getLength();
            IProcess process = (IProcess)this.console.getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_PROCESS");
            if (process != null) {
                String projectName;
                ILaunch launch = process.getLaunch();
                String projectAttribute = "PROJECT";
                String launchConfigurationType = launch.getLaunchConfiguration().getType().getIdentifier();
                if (launchConfigurationType.equals("org.eclipse.corrosion.debug.RustDebugDelegate")) {
                    projectAttribute = "org.eclipse.cdt.launch.PROJECT_ATTR";
                }
                if ((projectName = launch.getLaunchConfiguration().getAttribute(projectAttribute, "")).trim().isEmpty()) {
                    return;
                }
                IWorkspaceRoot myWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                IProject myProject = myWorkspaceRoot.getProject(projectName);
                String errorString = this.console.getDocument().get(event.getOffset(), event.getLength());
                String[] coordinates = errorString.split(":");
                IHyperlink link = ErrorLineMatcher.makeHyperlink(myProject.getFile(coordinates[0]), Integer.parseInt(coordinates[1]), Integer.parseInt(coordinates[2]));
                this.console.addHyperlink(link, offset, length);
            }
        }
        catch (CoreException | BadLocationException throwable) {
            // empty catch block
        }
    }

    private static IHyperlink makeHyperlink(final IFile file, final int lineNumber, final int lineOffset) {
        return new IHyperlink(){

            public void linkExited() {
            }

            public void linkEntered() {
            }

            public void linkActivated() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)page, (IFile)file);
                    ErrorLineMatcher.jumpToPosition(editorPart, lineNumber, lineOffset);
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        };
    }

    private static void jumpToPosition(IEditorPart editorPart, int lineNumber, int lineOffset) {
        ITextEditor textEditor;
        IDocument document;
        if (editorPart instanceof ITextEditor && (document = (textEditor = (ITextEditor)editorPart).getDocumentProvider().getDocument((Object)textEditor.getEditorInput())) != null) {
            IRegion region = null;
            try {
                region = document.getLineInformation(lineNumber - 1);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (region != null) {
                textEditor.selectAndReveal(region.getOffset() + lineOffset - 1, 0);
            }
        }
    }
}

