/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client;

import java.util.ArrayList;
import java.util.List;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.ServerEventHandler;
import org.eclipse.cft.server.core.internal.application.ModuleChangeEvent;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.CloudFoundryServerBehaviour;
import org.eclipse.cft.server.core.internal.client.ModulesOperation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;

public class DeleteModulesOperation
extends ModulesOperation {
    private final boolean deleteServices;
    private final IModule[] modules;

    public DeleteModulesOperation(CloudFoundryServerBehaviour cloudFoundryServerBehaviour, IModule[] modules, boolean deleteServices) {
        super(cloudFoundryServerBehaviour, modules.length > 0 ? modules[0] : null);
        this.modules = modules;
        this.deleteServices = deleteServices;
    }

    @Override
    public void runOnVerifiedModule(IProgressMonitor monitor) throws CoreException {
        this.doDelete(monitor);
        this.getBehaviour().asyncUpdateModuleAfterPublish(this.getFirstModule());
    }

    protected void doDelete(IProgressMonitor monitor) throws CoreException {
        CloudFoundryServer cloudServer = this.getBehaviour().getCloudFoundryServer();
        ArrayList<String> failedToDeleteApps = new ArrayList<String>();
        Throwable failedDeleteError = null;
        IModule[] iModuleArray = this.modules;
        int n = this.modules.length;
        int n2 = 0;
        while (n2 < n) {
            IModule module = iModuleArray[n2];
            CloudFoundryApplicationModule appModule = cloudServer.getExistingCloudModule(module);
            if (appModule != null && appModule.isDeployed()) {
                CloudApplication application;
                block9: {
                    application = null;
                    try {
                        application = this.getBehaviour().getCloudApplication(appModule.getDeployedApplicationName(), monitor);
                    }
                    catch (Throwable t) {
                        if (CloudErrorUtil.isNotFoundException(t)) break block9;
                        failedDeleteError = t;
                        failedToDeleteApps.add(appModule.getDeployedApplicationName());
                    }
                }
                ArrayList<String> servicesToDelete = new ArrayList<String>();
                if (application != null) {
                    List actualServices = application.getServices();
                    if (actualServices != null) {
                        for (String serviceName : actualServices) {
                            if (serviceName == null) continue;
                            servicesToDelete.add(serviceName);
                        }
                    }
                    this.getBehaviour().deleteApplication(application.getName(), monitor);
                }
                CloudFoundryPlugin.getCallback().stopApplicationConsole(appModule, cloudServer);
                cloudServer.removeApplication(appModule);
                ServerEventHandler.getDefault().fireServerEvent(new ModuleChangeEvent(this.getBehaviour().getCloudFoundryServer(), 420, appModule.getLocalModule(), Status.OK_STATUS));
                appModule.setCloudApplication(null);
                if (this.deleteServices && !servicesToDelete.isEmpty()) {
                    CloudFoundryPlugin.getCallback().deleteServices(servicesToDelete, cloudServer);
                }
            }
            ++n2;
        }
        if (!failedToDeleteApps.isEmpty() && failedDeleteError != null) {
            String errorMessage = NLS.bind((String)Messages.DeleteModulesOperation_ERROR_DELETE_APP_MESSAGE, failedToDeleteApps, (Object)failedDeleteError.getMessage());
            IStatus status = CloudFoundryPlugin.getErrorStatus(errorMessage, failedDeleteError);
            CloudFoundryPlugin.log(status);
        }
    }

    @Override
    public String getOperationName() {
        return Messages.DeleteModulesOperation_OPERATION_MESSAGE;
    }
}

