/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.wizards.module.example;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.ide.ui.wizards.module.example.IAcceleoInitializationStrategy;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public final class AcceleoInitializationStrategyUtils {
    private static List<IAcceleoInitializationStrategy> initializationStrategy;

    private AcceleoInitializationStrategyUtils() {
    }

    public static List<IAcceleoInitializationStrategy> getInitializationStrategy() {
        if (initializationStrategy == null) {
            initializationStrategy = new ArrayList<IAcceleoInitializationStrategy>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.acceleo.ide.ui.initialization");
            if (extensionPoint != null && extensionPoint.getExtensions().length > 0) {
                IExtension[] extensions = extensionPoint.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IExtension extension = extensions[i];
                    IConfigurationElement[] members = extension.getConfigurationElements();
                    int j = 0;
                    while (j < members.length) {
                        Status status;
                        IConfigurationElement member = members[j];
                        String strategyClass = member.getAttribute("class");
                        if (strategyClass != null) {
                            try {
                                Bundle bundle = Platform.getBundle((String)member.getNamespaceIdentifier());
                                Class c = bundle.loadClass(strategyClass);
                                IAcceleoInitializationStrategy exampleStrategy = (IAcceleoInitializationStrategy)c.newInstance();
                                initializationStrategy.add(exampleStrategy);
                            }
                            catch (ClassNotFoundException e) {
                                status = new Status(4, "org.eclipse.acceleo.ide.ui", 0, e.getMessage(), (Throwable)e);
                                AcceleoUIActivator.getDefault().getLog().log((IStatus)status);
                            }
                            catch (InstantiationException e) {
                                status = new Status(4, "org.eclipse.acceleo.ide.ui", 0, e.getMessage(), (Throwable)e);
                                AcceleoUIActivator.getDefault().getLog().log((IStatus)status);
                            }
                            catch (IllegalAccessException e) {
                                status = new Status(4, "org.eclipse.acceleo.ide.ui", 0, e.getMessage(), (Throwable)e);
                                AcceleoUIActivator.getDefault().getLog().log((IStatus)status);
                            }
                        } else {
                            String message = AcceleoUIMessages.getString("AcceleoNewTemplatesWizard.MissingStrategyClass", "org.eclipse.acceleo.ide.ui.initialization");
                            status = new Status(4, "org.eclipse.acceleo.ide.ui", 0, message, null);
                            AcceleoUIActivator.getDefault().getLog().log((IStatus)status);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        return initializationStrategy;
    }
}

