/*
 * Decompiled with CFR 0.152.
 */
package oshi.util.platform.linux;

import java.io.File;
import java.io.FileFilter;
import java.util.regex.Pattern;
import oshi.util.FileUtil;

public class ProcUtil {
    private static final Pattern DIGITS = Pattern.compile("\\d+");

    private ProcUtil() {
    }

    public static float getSystemUptimeFromProc() {
        String uptime = FileUtil.getStringFromFile("/proc/uptime");
        int spaceIndex = uptime.indexOf(32);
        try {
            if (spaceIndex < 0) {
                return Float.parseFloat(uptime);
            }
            return Float.parseFloat(uptime.substring(0, spaceIndex));
        }
        catch (NumberFormatException nfe) {
            return 0.0f;
        }
    }

    public static File[] getPidFiles() {
        File procdir = new File("/proc");
        File[] pids = procdir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return DIGITS.matcher(file.getName()).matches();
            }
        });
        return pids != null ? pids : new File[]{};
    }
}

