/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.freebsd;

import oshi.hardware.common.AbstractBaseboard;
import oshi.util.ExecutingCommand;

final class FreeBsdBaseboard
extends AbstractBaseboard {
    private static final long serialVersionUID = 1L;

    FreeBsdBaseboard() {
        this.init();
    }

    private void init() {
        String manufacturer = "";
        String manufacturerMarker = "Manufacturer:";
        String model = "";
        String productNameMarker = "Product Name:";
        String version = "";
        String versionMarker = "Version:";
        String serialNumber = "";
        String serialNumMarker = "Serial Number:";
        for (String checkLine : ExecutingCommand.runNative("dmidecode -t baseboard")) {
            if (checkLine.contains("Manufacturer:")) {
                manufacturer = checkLine.split("Manufacturer:")[1].trim();
            }
            if (checkLine.contains("Product Name:")) {
                model = checkLine.split("Product Name:")[1].trim();
            }
            if (checkLine.contains("Version:")) {
                version = checkLine.split("Version:")[1].trim();
            }
            if (!checkLine.contains("Serial Number:")) continue;
            serialNumber = checkLine.split("Serial Number:")[1].trim();
        }
        if (!manufacturer.isEmpty()) {
            this.setManufacturer(manufacturer);
        }
        if (!model.isEmpty()) {
            this.setModel(model);
        }
        if (!version.isEmpty()) {
            this.setVersion(version);
        }
        if (!serialNumber.isEmpty()) {
            this.setSerialNumber(serialNumber);
        }
    }
}

