/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.findrefs;

import com.google.inject.Inject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.search.ui.IQueryListener;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.ISearchResultPage;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.OpenAndLinkWithEditorHelper;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.xtext.ui.editor.findrefs.Messages;
import org.eclipse.xtext.ui.editor.findrefs.ReferenceSearchResultContentProvider;
import org.eclipse.xtext.ui.editor.findrefs.ReferenceSearchResultEvents;
import org.eclipse.xtext.ui.editor.findrefs.ReferenceSearchResultLabelProvider;
import org.eclipse.xtext.ui.editor.findrefs.ReferenceSearchViewPageActions;
import org.eclipse.xtext.ui.editor.findrefs.ReferenceSearchViewSorter;
import org.eclipse.xtext.ui.editor.navigation.NavigationService;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ReferenceSearchViewPage
extends Page
implements ISearchResultPage {
    private String id;
    private ISearchResult searchResult;
    private PageBook pagebook;
    private Table busyLabel;
    private Composite control;
    private TreeViewer viewer;
    private ISearchResultViewPart part;
    private MenuManager menu;
    private IAction showNextAction;
    private IAction showPreviousAction;
    private IAction expandAllAction;
    private IAction collapseAllAction;
    private IAction copyAction;
    private ReferenceSearchViewPageActions.RemoveSelectedMatchesAction removeSelectedMatchesAction;
    @Inject
    private ReferenceSearchResultContentProvider contentProvider;
    @Inject
    private ReferenceSearchResultLabelProvider labelProvider;
    @Inject
    private ReferenceSearchViewSorter sorter;
    @Inject
    private NavigationService navigationService;
    private boolean isBusyShowing;
    private IQueryListener queryListener;
    private final ISearchResultListener labelUpdater = e -> {
        if (this.viewer != null && !this.viewer.getControl().isDisposed() && (e instanceof ReferenceSearchResultEvents.Finish || e instanceof ReferenceSearchResultEvents.Removed)) {
            Display.getDefault().asyncExec(() -> this.part.updateLabel());
        }
    };

    public ReferenceSearchViewPage() {
        this.showPreviousAction = new ReferenceSearchViewPageActions.ShowPrevious(this);
        this.showNextAction = new ReferenceSearchViewPageActions.ShowNext(this);
        this.expandAllAction = new ReferenceSearchViewPageActions.ExpandAll(this);
        this.collapseAllAction = new ReferenceSearchViewPageActions.CollapseAll(this);
        this.copyAction = new ReferenceSearchViewPageActions.Copy(this);
        this.removeSelectedMatchesAction = new ReferenceSearchViewPageActions.RemoveSelectedMatchesAction(this);
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getLabel() {
        return this.searchResult == null ? "" : this.searchResult.getLabel();
    }

    public Object getUIState() {
        return this.viewer.getSelection();
    }

    public void restoreState(IMemento memento) {
    }

    public void saveState(IMemento memento) {
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInput(ISearchResult newSearchResult, Object uiState) {
        TreeViewer treeViewer = this.viewer;
        synchronized (treeViewer) {
            if (this.searchResult != null) {
                this.searchResult.removeListener(this.labelUpdater);
            }
            this.searchResult = newSearchResult;
            if (this.searchResult != null) {
                this.searchResult.addListener(this.labelUpdater);
                this.viewer.setInput((Object)newSearchResult);
                if (uiState instanceof ISelection) {
                    this.viewer.setSelection((ISelection)uiState);
                }
                this.removeSelectedMatchesAction.setSearchResult(this.searchResult);
            }
            this.part.updateLabel();
        }
    }

    public void setViewPart(ISearchResultViewPart part) {
        this.part = part;
    }

    public void createControl(Composite parent) {
        this.pagebook = new PageBook(parent, 0);
        this.pagebook.setLayoutData((Object)new GridData(1808));
        this.busyLabel = new Table((Composite)this.pagebook, 0);
        TableItem item = new TableItem(this.busyLabel, 0);
        item.setText(Messages.ReferenceSearchViewPage_busyLabel);
        this.busyLabel.setLayoutData((Object)new GridData(768));
        this.control = new Composite((Composite)this.pagebook, 0);
        this.control.setLayoutData((Object)new GridData(1808));
        this.control.setSize(100, 100);
        this.control.setLayout((Layout)new FillLayout());
        this.viewer = new TreeViewer(this.control, 770);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setSorter((ViewerSorter)this.sorter);
        this.createOpenAndLinkWithEditorHandler();
        IToolBarManager tbm = this.getSite().getActionBars().getToolBarManager();
        this.fillToolbar(tbm);
        tbm.update(true);
        this.pagebook.showPage((Control)this.control);
        this.isBusyShowing = false;
        this.queryListener = this.createQueryListener();
        NewSearchUI.addQueryListener((IQueryListener)this.queryListener);
        this.menu = new MenuManager("#PopUp");
        this.menu.setRemoveAllWhenShown(true);
        this.menu.setParent((IContributionManager)this.getSite().getActionBars().getMenuManager());
        this.menu.addMenuListener(mgr -> {
            this.fillContextMenu(mgr);
            this.part.fillContextMenu(mgr);
        });
        this.viewer.getControl().setMenu(this.menu.createContextMenu(this.viewer.getControl()));
        this.viewer.getControl().addKeyListener(KeyListener.keyPressedAdapter(e -> {
            if (e.keyCode == 127) {
                this.removeSelectedMatchesAction.run();
            } else if ((e.stateMask | 0x400000) != 0 && e.keyCode == 99) {
                this.copyAction.run();
            }
        }));
    }

    protected OpenAndLinkWithEditorHelper createOpenAndLinkWithEditorHandler() {
        return this.navigationService.installNavigationSupport((StructuredViewer)this.viewer, (Procedures.Procedure1<? super OpenEvent>)new Procedures.Procedure1<OpenEvent>(){

            public void apply(OpenEvent openEvent) {
                ReferenceSearchViewPage.this.handleOpen(openEvent);
            }
        });
    }

    protected IQueryListener createQueryListener() {
        return new IQueryListener(){

            public void queryStarting(ISearchQuery query) {
                ReferenceSearchViewPage.this.showBusyLabel(true);
            }

            public void queryRemoved(ISearchQuery query) {
                ReferenceSearchViewPage.this.showBusyLabel(false);
            }

            public void queryFinished(ISearchQuery query) {
                ReferenceSearchViewPage.this.showBusyLabel(false);
            }

            public void queryAdded(ISearchQuery query) {
                ReferenceSearchViewPage.this.showBusyLabel(false);
            }
        };
    }

    public void dispose() {
        NewSearchUI.removeQueryListener((IQueryListener)this.queryListener);
        super.dispose();
    }

    protected void showBusyLabel(final boolean shouldShowBusy) {
        if (shouldShowBusy != this.isBusyShowing) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (shouldShowBusy) {
                        ReferenceSearchViewPage.this.pagebook.showPage((Control)ReferenceSearchViewPage.this.busyLabel);
                    } else {
                        ReferenceSearchViewPage.this.pagebook.showPage((Control)ReferenceSearchViewPage.this.control);
                    }
                }
            });
            this.isBusyShowing = shouldShowBusy;
        }
    }

    protected void fillToolbar(IToolBarManager tbm) {
        tbm.appendToGroup("group.show", this.showNextAction);
        tbm.appendToGroup("group.show", this.showPreviousAction);
        IActionBars actionBars = this.getSite().getActionBars();
        if (actionBars != null) {
            actionBars.setGlobalActionHandler(ActionFactory.NEXT.getId(), this.showNextAction);
            actionBars.setGlobalActionHandler(ActionFactory.PREVIOUS.getId(), this.showPreviousAction);
        }
        tbm.appendToGroup("group.viewerSetup", this.expandAllAction);
        tbm.appendToGroup("group.viewerSetup", this.collapseAllAction);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add(this.copyAction);
        mgr.add((IAction)this.removeSelectedMatchesAction);
    }

    protected void handleOpen(OpenEvent openEvent) {
        this.navigationService.open(openEvent);
    }

    public Control getControl() {
        return this.pagebook;
    }

    public void setFocus() {
        Control control = this.viewer.getControl();
        if (control != null && !control.isDisposed()) {
            control.setFocus();
        }
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    protected ReferenceSearchResultContentProvider getContentProvider() {
        return this.contentProvider;
    }

    protected ReferenceSearchResultLabelProvider getLabelProvider() {
        return this.labelProvider;
    }
}

