/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.ui.internal.util;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.common.project.facet.ui.internal.util.GridLayoutUtil;
import org.eclipse.wst.common.project.facet.ui.internal.util.SwtUtil;

public abstract class HeaderToolTip
extends ToolTip {
    private static final String HEADER_BG_COLOR = String.valueOf(HeaderToolTip.class.getName()) + ".TOOLTIP_HEAD_BG_COLOR";
    private static final String HEADER_FG_COLOR = String.valueOf(HeaderToolTip.class.getName()) + ".TOOLTIP_HEAD_FG_COLOR";
    private static final String HEADER_FONT = String.valueOf(HeaderToolTip.class.getName()) + ".TOOLTIP_HEAD_FONT";

    static {
        JFaceResources.getColorRegistry().put(HEADER_BG_COLOR, new RGB(255, 255, 255));
        JFaceResources.getColorRegistry().put(HEADER_FG_COLOR, new RGB(0, 0, 0));
        String defaultFontName = JFaceResources.getDefaultFont().getFontData()[0].getName();
        FontData[] fontData = JFaceResources.getFontRegistry().getBold(defaultFontName).getFontData();
        JFaceResources.getFontRegistry().put(HEADER_FONT, fontData);
    }

    public HeaderToolTip(Control control) {
        super(control);
        this.setPopupDelay(1000);
        this.setShift(new Point(10, 3));
    }

    protected final Composite createToolTipContentArea(Event event, Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = GridLayoutUtil.glmargins(GridLayoutUtil.gl(1), 0, 0);
        layout.verticalSpacing = 1;
        composite.setLayout((Layout)layout);
        Composite topArea = new Composite(composite, 0);
        topArea.setBackground(JFaceResources.getColorRegistry().get(HEADER_BG_COLOR));
        topArea.setLayout((Layout)GridLayoutUtil.glmargins(GridLayoutUtil.gl(3), 5, 5, 2, 2));
        Label titleLabel = new Label(topArea, 0);
        titleLabel.setLayoutData((Object)GridLayoutUtil.gdfill());
        titleLabel.setBackground(JFaceResources.getColorRegistry().get(HEADER_BG_COLOR));
        titleLabel.setFont(JFaceResources.getFontRegistry().get(HEADER_FONT));
        titleLabel.setForeground(JFaceResources.getColorRegistry().get(HEADER_FG_COLOR));
        titleLabel.setText(this.getToolTipTitle(event));
        Composite content = this.createContentArea(event, composite);
        int width = Math.max(SwtUtil.getPreferredWidth((Control)titleLabel) + 50, 300);
        topArea.setLayoutData((Object)GridLayoutUtil.gdwhint(GridLayoutUtil.gdhfill(), width));
        content.setLayoutData((Object)GridLayoutUtil.gdwhint(GridLayoutUtil.gdfill(), width));
        return composite;
    }

    protected abstract String getToolTipTitle(Event var1);

    protected abstract Composite createContentArea(Event var1, Composite var2);
}

