/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.index;

import java.util.Collection;
import java.util.Map;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.rete.index.DualInputNode;
import org.eclipse.viatra.query.runtime.rete.index.Indexer;
import org.eclipse.viatra.query.runtime.rete.network.Direction;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.communication.Timestamp;

public class OuterJoinNode
extends DualInputNode {
    final Tuple defaults;
    private final DualInputNode.NetworkStructureChangeSensitiveLogic TIMELESS = new DualInputNode.NetworkStructureChangeSensitiveLogic(){

        @Override
        public void pullIntoWithTimestamp(Map<Tuple, Timestamp> collector, boolean flush) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void pullInto(Collection<Tuple> collector, boolean flush) {
            if (OuterJoinNode.this.primarySlot == null || OuterJoinNode.this.secondarySlot == null) {
                return;
            }
            if (flush) {
                OuterJoinNode.this.reteContainer.flushUpdates();
            }
            for (Tuple signature : OuterJoinNode.this.primarySlot.getSignatures()) {
                Collection<Tuple> primaries = OuterJoinNode.this.primarySlot.get(signature);
                Collection<Tuple> opposites = OuterJoinNode.this.secondarySlot.get(signature);
                if (opposites != null) {
                    for (Tuple primary : primaries) {
                        for (Tuple opposite : opposites) {
                            collector.add(OuterJoinNode.this.unify(primary, opposite));
                        }
                    }
                    continue;
                }
                for (Tuple primary : primaries) {
                    collector.add(OuterJoinNode.this.unifyWithDefaults(primary));
                }
            }
        }

        @Override
        public void notifyUpdate(DualInputNode.Side side, Direction direction, Tuple updateElement, Tuple signature, boolean change, Timestamp timestamp) {
            Collection<Tuple> opposites = OuterJoinNode.this.retrieveOpposites(side, signature);
            switch (side) {
                case PRIMARY: {
                    if (opposites != null) {
                        for (Tuple opposite : opposites) {
                            OuterJoinNode.this.propagateUpdate(direction, OuterJoinNode.this.unify(updateElement, opposite), timestamp);
                        }
                        break;
                    }
                    OuterJoinNode.this.propagateUpdate(direction, OuterJoinNode.this.unifyWithDefaults(updateElement), timestamp);
                    break;
                }
                case SECONDARY: {
                    if (opposites == null) break;
                    for (Tuple opposite : opposites) {
                        OuterJoinNode.this.propagateUpdate(direction, OuterJoinNode.this.unify(opposite, updateElement), timestamp);
                        if (!change) continue;
                        OuterJoinNode.this.propagateUpdate(direction.opposite(), OuterJoinNode.this.unifyWithDefaults(opposite), timestamp);
                    }
                    break;
                }
                case BOTH: {
                    for (Tuple opposite : opposites) {
                        OuterJoinNode.this.propagateUpdate(direction, OuterJoinNode.this.unify(updateElement, opposite), timestamp);
                        if (updateElement.equals((Object)opposite)) continue;
                        OuterJoinNode.this.propagateUpdate(direction, OuterJoinNode.this.unify(opposite, updateElement), timestamp);
                    }
                    if (direction != Direction.REVOKE) break;
                    OuterJoinNode.this.propagateUpdate(direction, OuterJoinNode.this.unify(updateElement, updateElement), timestamp);
                }
            }
        }
    };
    private final DualInputNode.NetworkStructureChangeSensitiveLogic TIMELY = new DualInputNode.NetworkStructureChangeSensitiveLogic(){

        @Override
        public void pullIntoWithTimestamp(Map<Tuple, Timestamp> collector, boolean flush) {
            if (OuterJoinNode.this.primarySlot == null || OuterJoinNode.this.secondarySlot == null) {
                return;
            }
            if (flush) {
                OuterJoinNode.this.reteContainer.flushUpdates();
            }
            for (Tuple signature : OuterJoinNode.this.primarySlot.getSignatures()) {
                Map<Tuple, Timestamp> primaries = OuterJoinNode.this.getWithTimestamp(signature, OuterJoinNode.this.primarySlot);
                Map<Tuple, Timestamp> opposites = OuterJoinNode.this.getWithTimestamp(signature, OuterJoinNode.this.secondarySlot);
                if (opposites != null) {
                    for (Tuple primary : primaries.keySet()) {
                        Timestamp primaryTimestamp = primaries.get(primary);
                        for (Tuple opposite : opposites.keySet()) {
                            collector.put(OuterJoinNode.this.unify(primary, opposite), primaryTimestamp.max(opposites.get(opposite)));
                        }
                    }
                    continue;
                }
                for (Tuple primary : primaries.keySet()) {
                    collector.put(OuterJoinNode.this.unifyWithDefaults(primary), primaries.get(primary));
                }
            }
        }

        @Override
        public void pullInto(Collection<Tuple> collector, boolean flush) {
            OuterJoinNode.this.TIMELESS.pullInto(collector, flush);
        }

        @Override
        public void notifyUpdate(DualInputNode.Side side, Direction direction, Tuple updateElement, Tuple signature, boolean change, Timestamp timestamp) {
            Indexer oppositeIndexer = OuterJoinNode.this.getSlot(side.opposite());
            Map<Tuple, Timestamp> opposites = OuterJoinNode.this.getWithTimestamp(signature, oppositeIndexer);
            switch (side) {
                case PRIMARY: {
                    if (opposites != null) {
                        for (Tuple opposite : opposites.keySet()) {
                            OuterJoinNode.this.propagateUpdate(direction, OuterJoinNode.this.unify(updateElement, opposite), timestamp.max(opposites.get(opposite)));
                        }
                        break;
                    }
                    OuterJoinNode.this.propagateUpdate(direction, OuterJoinNode.this.unifyWithDefaults(updateElement), timestamp);
                    break;
                }
                case SECONDARY: {
                    if (opposites == null) break;
                    for (Tuple opposite : opposites.keySet()) {
                        Timestamp oppositeTimestamp = opposites.get(opposite);
                        OuterJoinNode.this.propagateUpdate(direction, OuterJoinNode.this.unify(opposite, updateElement), timestamp.max(oppositeTimestamp));
                        if (!change) continue;
                        OuterJoinNode.this.propagateUpdate(direction.opposite(), OuterJoinNode.this.unifyWithDefaults(opposite), oppositeTimestamp);
                    }
                    break;
                }
                case BOTH: {
                    for (Tuple opposite : opposites.keySet()) {
                        Timestamp oppositeTimestamp = opposites.get(opposite);
                        OuterJoinNode.this.propagateUpdate(direction, OuterJoinNode.this.unify(updateElement, opposite), timestamp.max(oppositeTimestamp));
                        if (updateElement.equals((Object)opposite)) continue;
                        OuterJoinNode.this.propagateUpdate(direction, OuterJoinNode.this.unify(opposite, updateElement), timestamp.max(oppositeTimestamp));
                    }
                    if (direction != Direction.REVOKE) break;
                    OuterJoinNode.this.propagateUpdate(direction, OuterJoinNode.this.unify(updateElement, updateElement), timestamp);
                }
            }
        }
    };

    public OuterJoinNode(ReteContainer reteContainer, TupleMask complementerSecondaryMask, Tuple defaults) {
        super(reteContainer, complementerSecondaryMask);
        this.defaults = defaults;
        this.logic = this.createLogic();
    }

    @Override
    public Tuple calibrate(Tuple primary, Tuple secondary) {
        return this.unify(primary, secondary);
    }

    private Tuple unifyWithDefaults(Tuple ps) {
        return this.unify(ps, this.defaults);
    }

    @Override
    protected DualInputNode.NetworkStructureChangeSensitiveLogic createTimelessLogic() {
        return this.TIMELESS;
    }

    @Override
    protected DualInputNode.NetworkStructureChangeSensitiveLogic createTimelyLogic() {
        return this.TIMELY;
    }
}

