/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.util;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.viatra.query.runtime.matchers.memories.TimestampReplacement;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.util.Clearable;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;

public class TimelyMemory<Timestamp extends Comparable<Timestamp>>
implements Clearable {
    protected final Map<Tuple, TreeMap<Timestamp, Integer>> orderedTimestampMemory = CollectionsFactory.createMap();
    protected final Map<Tuple, Timestamp> leastTimestampMemory = CollectionsFactory.createMap();

    public TimestampReplacement<Timestamp> put(Tuple tuple, Timestamp timestamp) {
        Comparable oldLeast = (Comparable)this.leastTimestampMemory.get(tuple);
        TreeMap timestampMap = this.orderedTimestampMemory.computeIfAbsent(tuple, key -> CollectionsFactory.createTreeMap());
        timestampMap.merge(timestamp, 1, (o, n) -> o + 1);
        Comparable newLeast = null;
        if (oldLeast == null || timestamp.compareTo((Comparable)oldLeast) < 0) {
            newLeast = (Comparable)timestamp;
            this.leastTimestampMemory.put(tuple, newLeast);
        } else {
            newLeast = oldLeast;
        }
        return new TimestampReplacement<Comparable>(oldLeast, newLeast);
    }

    public TimestampReplacement<Timestamp> remove(Tuple tuple, Timestamp timestamp) {
        Comparable oldLeast = (Comparable)this.leastTimestampMemory.get(tuple);
        TreeMap<Timestamp, Integer> timestampMap = this.orderedTimestampMemory.get(tuple);
        if (timestampMap == null) {
            throw new IllegalStateException("Tuple " + tuple + " was not present in the memory when attempting removal!");
        }
        Integer count2 = timestampMap.get(timestamp);
        if (count2 == null) {
            throw new IllegalStateException("Timestamp " + timestamp + " for tuple " + tuple + " was not present in the memory when attempting removal!");
        }
        Comparable newLeast = null;
        if (count2 == 1) {
            timestampMap.remove(timestamp);
            if (timestampMap.isEmpty()) {
                this.orderedTimestampMemory.remove(tuple);
                this.leastTimestampMemory.remove(tuple);
            } else {
                Comparable firstKey = (Comparable)timestampMap.firstKey();
                this.leastTimestampMemory.put(tuple, firstKey);
                newLeast = firstKey;
            }
        } else {
            timestampMap.put(timestamp, count2 - 1);
            newLeast = oldLeast;
        }
        return new TimestampReplacement<Comparable>(oldLeast, newLeast);
    }

    public boolean isEmpty() {
        return this.leastTimestampMemory.isEmpty();
    }

    public int size() {
        return this.leastTimestampMemory.size();
    }

    public Set<Tuple> keySet() {
        return this.leastTimestampMemory.keySet();
    }

    public Map<Tuple, Timestamp> asMap() {
        return this.leastTimestampMemory;
    }

    public Timestamp get(ITuple tuple) {
        return (Timestamp)((Comparable)this.leastTimestampMemory.get(tuple));
    }

    @Override
    public void clear() {
        this.orderedTimestampMemory.clear();
        this.leastTimestampMemory.clear();
    }

    public boolean containsKey(ITuple tuple) {
        return this.leastTimestampMemory.containsKey(tuple);
    }
}

