/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.RemoteOperation;
import org.eclipse.ui.IWorkbenchPart;

public abstract class CheckoutOperation
extends RemoteOperation {
    public CheckoutOperation(IWorkbenchPart part, ICVSRemoteFolder[] remoteFolders) {
        super(part, (ICVSRemoteResource[])remoteFolders);
    }

    @Override
    public void execute(IProgressMonitor monitor) throws CVSException, InterruptedException {
        ICVSRemoteFolder[] folders = this.getRemoteFolders();
        this.checkout(folders, monitor);
    }

    protected void checkout(ICVSRemoteFolder[] folders, IProgressMonitor monitor) throws CVSException {
        monitor.beginTask(null, folders.length * 100);
        ICVSRemoteFolder[] iCVSRemoteFolderArray = folders;
        int n = folders.length;
        int n2 = 0;
        while (n2 < n) {
            ICVSRemoteFolder folder = iCVSRemoteFolderArray[n2];
            IStatus result = this.checkout(folder, Policy.subMonitorFor(monitor, 100));
            this.collectStatus(result);
            Policy.checkCanceled(monitor);
            ++n2;
        }
        monitor.done();
    }

    protected ICVSRemoteFolder[] getRemoteFolders() {
        return (ICVSRemoteFolder[])this.getRemoteResources();
    }

    protected abstract IStatus checkout(ICVSRemoteFolder var1, IProgressMonitor var2) throws CVSException;

    @Override
    public boolean canRunAsJob() {
        return true;
    }

    public boolean isKeepOneProgressServiceEntry() {
        return true;
    }

    protected IAction getGotoAction() {
        return this.getShowConsoleAction();
    }
}

