/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.ui.handler;

import java.util.EventObject;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.events.ChangeEvent;
import org.eclipse.tcf.te.runtime.events.EventManager;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.model.PendingOperationModelNode;
import org.eclipse.tcf.te.runtime.model.interfaces.IContainerModelNode;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.runtime.model.interfaces.contexts.IAsyncRefreshableCtx;
import org.eclipse.tcf.te.tcf.core.model.interfaces.IModel;
import org.eclipse.tcf.te.tcf.core.model.interfaces.services.IModelRefreshService;
import org.eclipse.tcf.te.tcf.processes.core.model.nodes.PendingOperationNode;
import org.eclipse.ui.handlers.HandlerUtil;

public class RefreshHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            List nodes = ((IStructuredSelection)selection).toList();
            for (IModelNode node : nodes) {
                if (node instanceof IModel) {
                    final IModel model = (IModel)node;
                    Assert.isNotNull((Object)model);
                    final IAsyncRefreshableCtx refreshable = (IAsyncRefreshableCtx)model.getAdapter(IAsyncRefreshableCtx.class);
                    if (refreshable == null) continue;
                    if (refreshable.getQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST).equals((Object)IAsyncRefreshableCtx.QueryState.IN_PROGRESS)) {
                        return null;
                    }
                    refreshable.setQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST, IAsyncRefreshableCtx.QueryState.IN_PROGRESS);
                    PendingOperationNode pendingNode = new PendingOperationNode();
                    pendingNode.setParent((IContainerModelNode)model);
                    refreshable.setPendingOperationNode((PendingOperationModelNode)pendingNode);
                    ChangeEvent changeEvent = new ChangeEvent((Object)model, (Object)"changed", null, null);
                    EventManager.getInstance().fireEvent((EventObject)changeEvent);
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            final boolean changed = model.setChangeEventsEnabled(false);
                            ((IModelRefreshService)model.getService(IModelRefreshService.class)).refresh((ICallback)new Callback(){

                                protected void internalDone(Object caller, IStatus status) {
                                    refreshable.setQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST, IAsyncRefreshableCtx.QueryState.DONE);
                                    refreshable.setPendingOperationNode(null);
                                    if (changed) {
                                        model.setChangeEventsEnabled(true);
                                    }
                                    ChangeEvent event = new ChangeEvent((Object)model, (Object)"changed", null, null);
                                    EventManager.getInstance().fireEvent((EventObject)event);
                                }
                            });
                        }
                    };
                    Protocol.invokeLater((Runnable)runnable);
                    continue;
                }
                final IModelNode finNode = node;
                Protocol.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        IModel model = (IModel)finNode.getParent(IModel.class);
                        Assert.isNotNull((Object)model);
                        ((IModelRefreshService)model.getService(IModelRefreshService.class)).refresh(finNode, null);
                    }
                });
            }
        }
        return null;
    }
}

