/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.impl.toolbar;

import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.core.exception.Thrower;
import org.eclipse.reddeer.core.handler.ToolItemHandler;
import org.eclipse.reddeer.core.lookup.ToolItemLookup;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.swt.api.Control;
import org.eclipse.reddeer.swt.api.ToolBar;
import org.eclipse.reddeer.swt.impl.toolbar.DefaultToolBar;
import org.eclipse.reddeer.swt.widgets.AbstractItem;
import org.eclipse.swt.widgets.ToolItem;
import org.hamcrest.Matcher;

public abstract class AbstractToolItem
extends AbstractItem<ToolItem>
implements org.eclipse.reddeer.swt.api.ToolItem {
    private static final Logger log = Logger.getLogger(AbstractToolItem.class);

    protected AbstractToolItem(ReferencedComposite refComposite, int index, Matcher<?> ... matchers) {
        super(ToolItem.class, refComposite == null ? ToolItemLookup.getInstance().findReferencedComposite() : refComposite, index, matchers);
    }

    protected AbstractToolItem(ToolItem widget) {
        super(widget);
    }

    @Override
    public void click() {
        Thrower.objectIsNull(this.getSWTWidget(), (String)"ToolItem is null");
        log.info("Click tool item " + this.getToolTipText());
        ToolItemHandler.getInstance().click((ToolItem)this.getSWTWidget());
    }

    @Override
    public String getToolTipText() {
        String tooltipText = ToolItemHandler.getInstance().getToolTipText((ToolItem)this.swtWidget);
        return tooltipText;
    }

    @Override
    public boolean isSelected() {
        return ToolItemHandler.getInstance().isSelected((ToolItem)this.swtWidget);
    }

    @Override
    public void toggle(boolean toggle) {
        log.info(String.valueOf(toggle ? "Click" : "Unclick") + " tool item " + this.getToolTipText());
        if (this.isSelected() != toggle) {
            this.click();
        }
    }

    @Override
    public boolean isEnabled() {
        return ToolItemHandler.getInstance().isEnabled((ToolItem)this.swtWidget);
    }

    @Override
    public ToolBar getParent() {
        return new DefaultToolBar(ToolItemHandler.getInstance().getParent((ToolItem)this.swtWidget));
    }

    @Override
    public Control<?> getParentControl() {
        return this.getParent();
    }
}

